/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.settings;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.SoundChoiceBox;
import com.deutscheboerse.comxerv.comtrader.jfx.service.sound.SoundEvent;
import com.deutscheboerse.comxerv.comtrader.jfx.service.sound.SoundService;
import com.deutscheboerse.comxerv.comtrader.jfx.service.sound.SoundType;
import com.google.common.eventbus.EventBus;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;

public class SoundEventEntry
extends HBox {
    private final SoundService soundService;
    private final SoundEvent soundEvent;
    @FXML
    private Button playButton;
    @FXML
    private SoundChoiceBox soundsChoiceBox;
    @FXML
    private Label eventName;

    public SoundEventEntry(ApplicationContext appContext, SoundEvent soundEvent, SoundType sound) {
        this.soundEvent = soundEvent;
        this.soundService = appContext.getService(SoundService.class);
        appContext.getService(EventBus.class).register(this);
        FXMLLoaderWithContext.loadCustomComponent(appContext, this);
        this.eventName.setText(soundEvent.getDisplayName());
        this.soundsChoiceBox.setValue(sound);
    }

    public void initialize() {
        this.playButton.disableProperty().bind(this.soundsChoiceBox.valueProperty().isEqualTo((Object)SoundType.OFF));
    }

    public SoundEvent getSoundEvent() {
        return this.soundEvent;
    }

    @FXML
    public void playPreview() {
        SoundType selectedSoundType = (SoundType)((Object)this.soundsChoiceBox.getSelectionModel().getSelectedItem());
        this.soundService.playSound(selectedSoundType);
    }

    public SoundType getSelectedSoundType() {
        return (SoundType)((Object)this.soundsChoiceBox.getValue());
    }

    public void setSelectedSoundType(SoundType soundType) {
        this.soundsChoiceBox.setValue(soundType);
    }
}

