/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.settings;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookEntryType;
import com.deutscheboerse.comxerv.comtrader.entities.type.LogoutActionType;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.NumberTextField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.settings.SettingsSection;
import com.deutscheboerse.comxerv.comtrader.jfx.components.settings.TradingActionChoiceBox;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfiguration;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfigurationsExecutor;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.gui.AllDescendantsByIdOverrideGuiStrategy;
import com.deutscheboerse.comxerv.comtrader.jfx.util.converter.DisplayNameConverter;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.protection.CrossTradeProtectionService;
import com.deutscheboerse.comxerv.comtrader.service.trade.TradingAction;
import com.deutscheboerse.comxerv.comtrader.service.trade.TradingMouseActions;
import com.deutscheboerse.comxerv.comtrader.service.trade.TradingSettingsService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import java.util.Objects;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.layout.GridPane;
import javafx.util.StringConverter;
import org.apache.commons.lang3.StringUtils;

@OverrideGuiConfiguration(field="#this", overrideId="TradingSettingsPane", strategy=AllDescendantsByIdOverrideGuiStrategy.class)
public class TradingSettingsPane
extends GridPane
implements SettingsSection {
    private final ApplicationContext appContext;
    private final CrossTradeProtectionService crossTradeProtectionService;
    private final TradingSettingsService tradingSettingsService;
    @FXML
    private CheckBox orderEntryConfirmationCheckBox;
    @FXML
    private CheckBox crossTradeProtectionCheckBox;
    @FXML
    private ChoiceBox<Boolean> defaultContractExpansionStateCheckBox;
    @FXML
    private CheckBox waitForOrderConfirmationCheckBox;
    @FXML
    private CheckBox basketValidationCheckBox;
    @FXML
    private CheckBox defaultAotCheckBox;
    @FXML
    private ChoiceBox<LogoutActionType> logoutSettingsChoiceBox;
    @FXML
    private TradingActionChoiceBox leftMouseOverview;
    @FXML
    private TradingActionChoiceBox leftMouseDetails;
    @FXML
    private TradingActionChoiceBox rightMouseOverview;
    @FXML
    private TradingActionChoiceBox rightMouseDetails;
    @FXML
    private TradingActionChoiceBox ctrlLeftMouseOverview;
    @FXML
    private TradingActionChoiceBox ctrlLeftMouseDetails;
    @FXML
    private TradingActionChoiceBox ctrlRightMouseOverview;
    @FXML
    private TradingActionChoiceBox ctrlRightMouseDetails;
    @FXML
    private TradingActionChoiceBox shiftLeftMouseOverview;
    @FXML
    private TradingActionChoiceBox shiftLeftMouseDetails;
    @FXML
    private TradingActionChoiceBox shiftRightMouseOverview;
    @FXML
    private TradingActionChoiceBox shiftRightMouseDetails;
    @FXML
    private NumberTextField popupGroupLimit;

    public TradingSettingsPane() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public TradingSettingsPane(ApplicationContext appContext) {
        this.appContext = appContext;
        this.crossTradeProtectionService = appContext.getService(CrossTradeProtectionService.class);
        this.tradingSettingsService = appContext.getService(TradingSettingsService.class);
        FXMLLoaderWithContext.loadCustomComponent(appContext, this);
    }

    public void initialize() {
        this.logoutSettingsChoiceBox.getItems().addAll((LogoutActionType[])LogoutActionType.values());
        this.logoutSettingsChoiceBox.setConverter(new DisplayNameConverter());
        this.refreshSettings();
        this.appContext.getService(OverrideGuiConfigurationsExecutor.class).registerAndApply(this);
        this.defaultContractExpansionStateCheckBox.getItems().addAll((Boolean[])new Boolean[]{true, false});
        this.defaultContractExpansionStateCheckBox.setConverter(new StringConverter<Boolean>(this){

            @Override
            public String toString(Boolean object) {
                return object != false ? Util.getLabel("commons_expanded") : Util.getLabel("commons_collapsed");
            }

            @Override
            public Boolean fromString(String string) {
                return null;
            }
        });
    }

    @Override
    public boolean applyChanges() {
        this.crossTradeProtectionService.setEnabled(this.crossTradeProtectionCheckBox.isSelected());
        this.tradingSettingsService.storeMouseActionsSettings(this.collectTradingMouseActions());
        this.tradingSettingsService.storeOrderEntryConfirmationSettings(this.orderEntryConfirmationCheckBox.isSelected());
        this.tradingSettingsService.storeLogoutSettings(this.logoutSettingsChoiceBox.getValue());
        this.tradingSettingsService.storeExpandMarketOverviewItemsOnAdding(this.defaultContractExpansionStateCheckBox.getValue());
        this.tradingSettingsService.storeWaitForOrderConfirmation(this.waitForOrderConfirmationCheckBox.isSelected());
        this.tradingSettingsService.storeBasketValidation(this.basketValidationCheckBox.isSelected());
        this.tradingSettingsService.storeDefaultAot(this.defaultAotCheckBox.isSelected());
        this.tradingSettingsService.storeTradeCancelPopupGroupLimit(StringUtils.isEmpty(this.popupGroupLimit.getText()) ? null : Integer.valueOf(this.popupGroupLimit.getText()));
        return true;
    }

    @Override
    public void cancelChanges() {
        this.refreshSettings();
    }

    @Override
    public void resetToDefault() {
        this.crossTradeProtectionCheckBox.setSelected(true);
        this.populateTradingMouseActions(TradingSettingsService.DEFAULT_MOUSE_ACTIONS);
        this.orderEntryConfirmationCheckBox.setSelected(false);
        this.logoutSettingsChoiceBox.setValue(TradingSettingsService.DEFAULT_LOGOUT_TYPE);
        this.defaultContractExpansionStateCheckBox.setValue(false);
        this.waitForOrderConfirmationCheckBox.setSelected(false);
        this.basketValidationCheckBox.setSelected(true);
        this.defaultAotCheckBox.setSelected(true);
        this.popupGroupLimit.setText(Objects.toString(this.tradingSettingsService.getTradeCancelPopupGroupLimitDefault(), null));
    }

    private void refreshSettings() {
        this.crossTradeProtectionCheckBox.setSelected(this.crossTradeProtectionService.isEnabled());
        this.populateTradingMouseActions(this.tradingSettingsService.getTradingMouseActions());
        this.orderEntryConfirmationCheckBox.setSelected(this.tradingSettingsService.isOrderEntryConfirmationEnabled());
        this.logoutSettingsChoiceBox.setValue(this.tradingSettingsService.getLogoutSettings());
        this.defaultContractExpansionStateCheckBox.setValue(this.tradingSettingsService.isExpandMarketOverviewItemsOnAddingEnabled());
        this.waitForOrderConfirmationCheckBox.setSelected(this.tradingSettingsService.isWaitForOrderConfirmation());
        this.basketValidationCheckBox.setSelected(this.tradingSettingsService.isBasketValidation());
        this.defaultAotCheckBox.setSelected(this.tradingSettingsService.isDefaultAot());
        this.popupGroupLimit.setText(Objects.toString(this.tradingSettingsService.getTradeCancelPopupGroupLimit(), null));
    }

    private TradingMouseActions collectTradingMouseActions() {
        return new TradingMouseActions((TradingAction)this.leftMouseOverview.getValue(), (TradingAction)this.leftMouseDetails.getValue(), (TradingAction)this.rightMouseOverview.getValue(), (TradingAction)this.rightMouseDetails.getValue(), (TradingAction)this.ctrlLeftMouseOverview.getValue(), (TradingAction)this.ctrlLeftMouseDetails.getValue(), (TradingAction)this.ctrlRightMouseOverview.getValue(), (TradingAction)this.ctrlRightMouseDetails.getValue(), (TradingAction)this.shiftLeftMouseOverview.getValue(), (TradingAction)this.shiftLeftMouseDetails.getValue(), (TradingAction)this.shiftRightMouseOverview.getValue(), (TradingAction)this.shiftRightMouseDetails.getValue());
    }

    private void populateTradingMouseActions(TradingMouseActions actions) {
        TradingSettingsPane.setTradingAction(this.leftMouseOverview, actions.getLeftMouseAction(OrderbookEntryType.AGGREGATED));
        TradingSettingsPane.setTradingAction(this.leftMouseDetails, actions.getLeftMouseAction(OrderbookEntryType.NOT_AGGREGATED));
        TradingSettingsPane.setTradingAction(this.rightMouseOverview, actions.getRightMouseAction(OrderbookEntryType.AGGREGATED));
        TradingSettingsPane.setTradingAction(this.rightMouseDetails, actions.getRightMouseAction(OrderbookEntryType.NOT_AGGREGATED));
        TradingSettingsPane.setTradingAction(this.ctrlLeftMouseOverview, actions.getCtrlLeftMouseAction(OrderbookEntryType.AGGREGATED));
        TradingSettingsPane.setTradingAction(this.ctrlLeftMouseDetails, actions.getCtrlLeftMouseAction(OrderbookEntryType.NOT_AGGREGATED));
        TradingSettingsPane.setTradingAction(this.ctrlRightMouseOverview, actions.getCtrlRightMouseAction(OrderbookEntryType.AGGREGATED));
        TradingSettingsPane.setTradingAction(this.ctrlRightMouseDetails, actions.getCtrlRightMouseAction(OrderbookEntryType.NOT_AGGREGATED));
        TradingSettingsPane.setTradingAction(this.shiftLeftMouseOverview, actions.getShiftLeftMouseAction(OrderbookEntryType.AGGREGATED));
        TradingSettingsPane.setTradingAction(this.shiftLeftMouseDetails, actions.getShiftLeftMouseAction(OrderbookEntryType.NOT_AGGREGATED));
        TradingSettingsPane.setTradingAction(this.shiftRightMouseOverview, actions.getShiftRightMouseAction(OrderbookEntryType.AGGREGATED));
        TradingSettingsPane.setTradingAction(this.shiftRightMouseDetails, actions.getShiftRightMouseAction(OrderbookEntryType.NOT_AGGREGATED));
    }

    private static void setTradingAction(TradingActionChoiceBox tradeActionChoiceBox, TradingAction tradingAction) {
        tradeActionChoiceBox.setValue(tradeActionChoiceBox.getListedItems().contains(tradingAction) ? tradingAction : TradingAction.NO_ACTION);
    }
}

