/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.table.common;

import com.deutscheboerse.comxerv.comtrader.jfx.components.icon.IconView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.GenericCellCustomizer;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.OverrunStyle;
import javafx.scene.control.TableCell;
import javafx.scene.control.Tooltip;

public class HintCellCustomizer<S>
extends GenericCellCustomizer<S, String> {
    private static final String ICON = "icon-info-20";

    @Override
    protected Node getGraphic(String cellItem, S rowValue, Node defaultGraphic) {
        return cellItem != null ? new IconView(ICON) : null;
    }

    @Override
    protected void customizeTableCell(TableCell<S, String> tableCell) {
        String hintText = (String)tableCell.getItem();
        if (hintText != null) {
            Tooltip tooltip = new Tooltip(hintText);
            tooltip.setWrapText(true);
            tooltip.setTextOverrun(OverrunStyle.CENTER_ELLIPSIS);
            tableCell.setTooltip(tooltip);
            tableCell.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        }
    }
}

