/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.table.order;

import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.order.AbstractOrderTooltip;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.google.inject.Singleton;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@Singleton
public class OtcOrderRowTooltip
extends AbstractOrderTooltip {
    private final DateTimeFormatter dateFormat = DateTimeFormat.forPattern(Util.getLabel("commons_datePatternSec"));

    @Override
    protected String getValidOrderTooltipText(Order order) {
        StringBuilder sb = new StringBuilder();
        sb.append(Util.getLabel("commons_quantityShort")).append(": ").append(order.getRemainingQuantity()).append(System.lineSeparator());
        sb.append(Util.getLabel("commons_priceShort")).append(": ").append(order.getLimitPrice()).append(System.lineSeparator());
        if (order.getBalancingGroup() != null) {
            sb.append(Util.getLabel("commons_originatorBalancingGroupShort")).append(": ").append(order.getBalancingGroup().getName()).append(System.lineSeparator());
        }
        if (order.getPreArrangedBalancingGroup() != null) {
            sb.append(Util.getLabel("commons_receiverBalancingGroupIdShort")).append(": ").append(order.getPreArrangedBalancingGroup().getName()).append(System.lineSeparator());
        }
        sb.append(Util.getLabel("commons_timestamp")).append(": ").append(this.dateFormat.print(order.getTimeStamp())).append(System.lineSeparator());
        return sb.toString();
    }
}

