/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.table.orderbook;

import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.type.ValueChange;
import com.deutscheboerse.comxerv.comtrader.jfx.service.csv.ExportableCellValue;
import com.deutscheboerse.comxerv.comtrader.service.LocalService;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class LastPriceValue
implements ExportableCellValue {
    private final LongDisplayValue lastPrice;
    private final ValueChange valueChange;

    public LastPriceValue(LongDisplayValue lastPrice, ValueChange valueChange) {
        this.lastPrice = lastPrice;
        this.valueChange = valueChange;
    }

    @Override
    public List<Object> getExportedCellValue(LocalService localService) {
        return Collections.singletonList(this.lastPrice != null ? localService.format(this.lastPrice.getDisplayValue()) : "");
    }

    public LongDisplayValue getLastPrice() {
        return this.lastPrice;
    }

    public ValueChange getPriceChange() {
        return this.valueChange;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LastPriceValue that = (LastPriceValue)o;
        return Objects.equals(this.lastPrice, that.lastPrice) && this.valueChange == that.valueChange;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.lastPrice, this.valueChange});
    }
}

