/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.table.orderbook;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.domain.query.OrderbookQueries;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookValueWrapper;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.AbstractAreaChoiceBox;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.DeliveryAreaAssignedToUserChoiceBox;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.DeliveryAreaChoiceBox;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.GenericCellCustomizer;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.scene.Node;

public class OrderbookDeliveryAreaCellCustomizer
extends GenericCellCustomizer<OrderbookValueWrapper, DeliveryArea> {
    private final ApplicationContext applicationContext;
    private DeliveryAreaChoiceBox switchAllChoiceBox;

    public OrderbookDeliveryAreaCellCustomizer() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    protected OrderbookDeliveryAreaCellCustomizer(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    protected Node getGraphic(DeliveryArea cellItem, OrderbookValueWrapper rowValue, Node defaultGraphic) {
        return new OrderbookValueWrapperDeliveryAreaChoiceBox(this.applicationContext, rowValue, this.switchAllChoiceBox);
    }

    public DeliveryAreaChoiceBox getSwitchAllChoiceBox() {
        return this.switchAllChoiceBox;
    }

    public void setSwitchAllChoiceBox(DeliveryAreaChoiceBox switchAllChoiceBox) {
        this.switchAllChoiceBox = switchAllChoiceBox;
    }

    private static class OrderbookValueWrapperDeliveryAreaChoiceBox
    extends DeliveryAreaAssignedToUserChoiceBox {
        private final DeliveryAreaChoiceBox switchAllChoiceBox;
        private final OrderbookQueries orderbookQueries;
        private final OrderbookValueWrapper orderbookValueWrapper;
        private final ChangeListener<Orderbook> orderbookChangeListener;
        private final WeakChangeListener<Orderbook> weakOrderbookChangeListener;
        private final ChangeListener<DeliveryArea> deliveryAreaChangeListener;
        private final WeakChangeListener<DeliveryArea> weakDeliveryAreaChangeListener;

        public OrderbookValueWrapperDeliveryAreaChoiceBox(ApplicationContext appContext, OrderbookValueWrapper orderbookValueWrapper, DeliveryAreaChoiceBox switchAllChoiceBox) {
            super(appContext);
            this.orderbookValueWrapper = orderbookValueWrapper;
            this.orderbookQueries = appContext.getService(OrderbookQueries.class);
            this.switchAllChoiceBox = switchAllChoiceBox;
            this.setListedItemsMode(AbstractAreaChoiceBox.ListedItemsMode.ALL_ACTIVE);
            this.setContract(orderbookValueWrapper.getOrderbook().getContract());
            this.setValue(orderbookValueWrapper.getOrderbook().getDeliveryArea());
            this.orderbookChangeListener = this::orderbookValueChanged;
            this.weakOrderbookChangeListener = new WeakChangeListener<Orderbook>(this.orderbookChangeListener);
            orderbookValueWrapper.orderbookProperty().addListener(this.weakOrderbookChangeListener);
            this.deliveryAreaChangeListener = this::deliveryAreaChanged;
            this.weakDeliveryAreaChangeListener = new WeakChangeListener<DeliveryArea>(this.deliveryAreaChangeListener);
            this.valueProperty().addListener(this.weakDeliveryAreaChangeListener);
        }

        private void deliveryAreaChanged(ObservableValue<? extends DeliveryArea> observable2, DeliveryArea oldValue, DeliveryArea newValue) {
            this.orderbookQueries.findByContractAndDeliveryArea(this.orderbookValueWrapper.getOrderbook().getContract(), newValue).ifPresent(this::loadOrderbook);
        }

        private void loadOrderbook(Orderbook orderbook) {
            this.orderbookValueWrapper.setOrderbook(orderbook);
            if (this.switchAllChoiceBox.getValue() != null && !((DeliveryArea)this.switchAllChoiceBox.getValue()).equals(orderbook.getDeliveryArea())) {
                this.switchAllChoiceBox.setValue(null);
            }
        }

        private void orderbookValueChanged(ObservableValue<? extends Orderbook> observable2, Orderbook oldValue, Orderbook newValue) {
            if (newValue != null) {
                this.setValue(newValue.getDeliveryArea());
            }
        }
    }
}

