/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.table.orderbook;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.BestOrderbookEntry;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.CommonOrderbookEntry;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookEntryType;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.listener.BatchUpdateAdapter;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.listener.BatchUpdateListener;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.listener.WeakBatchUpdateListener;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.CollapsibleValueOrderbookWrapper;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.ColorInvalidationListener;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.orderbook.CollapsibleOrderbookEntries;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.orderbook.EntryTextWithFlash;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.orderbook.OrderbookEntryTableCellClickHandler;
import com.deutscheboerse.comxerv.comtrader.jfx.service.SelectedCellService;
import com.deutscheboerse.comxerv.comtrader.jfx.service.trade.TradingActionService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.action.OrderActionsService;
import com.deutscheboerse.ui.jfx.util.StyleUtil;
import com.deutscheboerse.ui.jfx.util.binding.ConstantObservableValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Labeled;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import javafx.util.Callback;

public class OrderbookEntriesCellFactory
implements Callback<TableColumn<CollapsibleValueOrderbookWrapper, CollapsibleOrderbookEntries>, TableCell<CollapsibleValueOrderbookWrapper, CollapsibleOrderbookEntries>> {
    private static final String MULTI_LINE_ORDERBOOK_CELL_STYLE = "multiLineOrderbookCell";
    private final ApplicationContext appContext;
    protected final SelectedCellService selectedCellService;
    protected final TradingActionService tradingActionService;
    private FlashTrigger flashTrigger;
    private OrderActionsService.PreparedOrderQuantitySelector quantitySelector;

    public OrderbookEntriesCellFactory() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public OrderbookEntriesCellFactory(ApplicationContext appContext) {
        this.appContext = appContext;
        this.selectedCellService = appContext.getService(SelectedCellService.class);
        this.tradingActionService = appContext.getService(TradingActionService.class);
        this.flashTrigger = FlashTrigger.NONE;
        this.quantitySelector = OrderActionsService.PreparedOrderQuantitySelector.FIRM;
    }

    @Override
    public TableCell<CollapsibleValueOrderbookWrapper, CollapsibleOrderbookEntries> call(TableColumn<CollapsibleValueOrderbookWrapper, CollapsibleOrderbookEntries> tableColumn) {
        EntryListTableCell entryListTableCell = new EntryListTableCell();
        ColorInvalidationListener.registerForColoredTableColumn(tableColumn, entryListTableCell);
        EventHandler<MouseEvent> clichHandler = this.selectedCellService.getListenerAsMouseEventHandler(entryListTableCell);
        entryListTableCell.addEventHandler(MouseEvent.MOUSE_CLICKED, clichHandler);
        return entryListTableCell;
    }

    public FlashTrigger getFlashTrigger() {
        return this.flashTrigger;
    }

    public void setFlashTrigger(FlashTrigger flashTrigger) {
        this.flashTrigger = flashTrigger;
    }

    public OrderActionsService.PreparedOrderQuantitySelector getQuantitySelector() {
        return this.quantitySelector;
    }

    public void setQuantitySelector(OrderActionsService.PreparedOrderQuantitySelector quantitySelector) {
        this.quantitySelector = quantitySelector;
    }

    protected ApplicationContext getAppContext() {
        return this.appContext;
    }

    public static enum FlashTrigger {
        PRICE(BestOrderbookEntry::priceProperty),
        FIRM_QUANTITY(BestOrderbookEntry::quantityProperty),
        OWN_FIRM_QUANTITY(BestOrderbookEntry::ownQuantityProperty),
        NONE(entry -> ConstantObservableValue.nullValue());

        private final Function<BestOrderbookEntry, ObservableValue<LongDisplayValue>> flashTriggerFunction;

        private FlashTrigger(Function<BestOrderbookEntry, ObservableValue<LongDisplayValue>> flashTriggerFunction) {
            this.flashTriggerFunction = flashTriggerFunction;
        }
    }

    private final class EntryListTableCell
    extends TableCell<CollapsibleValueOrderbookWrapper, CollapsibleOrderbookEntries> {
        private final ChangeListener<LongDisplayValue> flashTriggerChangeListener;
        private final ChangeListener<LongDisplayValue> weakFlashTriggerChangeListener;
        private final BatchUpdateListener<CommonOrderbookEntry> entriesUpdateListener;
        private final BatchUpdateListener<CommonOrderbookEntry> weakEntriesUpdateListener;
        private final InvalidationListener rowLimitInvalidationListener;
        private final WeakInvalidationListener weakRowLimitInvalidationListener;
        private final VBox contentContainer;
        private final List<Node> rowsToRemove;
        private final List<Node> newRows = new LinkedList<Node>();

        private EntryListTableCell() {
            this.rowsToRemove = new LinkedList<Node>();
            this.setAlignment(Pos.CENTER);
            StyleUtil.addStyleClass(this, OrderbookEntriesCellFactory.MULTI_LINE_ORDERBOOK_CELL_STYLE);
            this.contentContainer = new VBox();
            this.contentContainer.setPadding(new Insets(4.0, 0.0, 4.0, 0.0));
            this.contentContainer.setAlignment(Pos.TOP_RIGHT);
            this.contentContainer.setFillWidth(true);
            this.setGraphic(this.contentContainer);
            this.flashTriggerChangeListener = (observableValue, oldValue, newValue) -> {
                if (!Objects.equals(newValue, oldValue) && !((VBox)this.getGraphic()).getChildren().isEmpty()) {
                    EntryTextWithFlash entryTextWithFlash = (EntryTextWithFlash)((VBox)this.getGraphic()).getChildren().get(0);
                    entryTextWithFlash.flash();
                }
            };
            this.weakFlashTriggerChangeListener = new WeakChangeListener<LongDisplayValue>(this.flashTriggerChangeListener);
            this.entriesUpdateListener = BatchUpdateAdapter.batchFinishedListener(() -> {
                ArrayList<CommonOrderbookEntry> listSnapshot = new ArrayList<CommonOrderbookEntry>(((CollapsibleOrderbookEntries)this.getItem()).getEntries());
                this.updateContent(listSnapshot);
            });
            this.weakEntriesUpdateListener = new WeakBatchUpdateListener<CommonOrderbookEntry>(this.entriesUpdateListener);
            this.rowLimitInvalidationListener = observable2 -> {
                CollapsibleOrderbookEntries item = (CollapsibleOrderbookEntries)this.getItem();
                if (item != null) {
                    this.updateContent(new ArrayList<CommonOrderbookEntry>(item.getEntries()));
                }
            };
            this.weakRowLimitInvalidationListener = new WeakInvalidationListener(this.rowLimitInvalidationListener);
            this.itemProperty().addListener((observableValue, oldValue, newValue) -> {
                ObservableValue<LongDisplayValue> flashTrigger;
                if (oldValue != null) {
                    flashTrigger = OrderbookEntriesCellFactory.this.flashTrigger.flashTriggerFunction.apply(oldValue.getBestOrderbookEntries());
                    flashTrigger.removeListener(this.weakFlashTriggerChangeListener);
                    oldValue.getBatchUpdatable().removeListener(this.weakEntriesUpdateListener);
                    oldValue.rowLimitProperty().removeListener(this.weakRowLimitInvalidationListener);
                }
                if (newValue != null) {
                    this.updateContent(new ArrayList<CommonOrderbookEntry>(newValue.getEntries()));
                    flashTrigger = OrderbookEntriesCellFactory.this.flashTrigger.flashTriggerFunction.apply(newValue.getBestOrderbookEntries());
                    flashTrigger.addListener(this.weakFlashTriggerChangeListener);
                    newValue.getBatchUpdatable().addListener(this.weakEntriesUpdateListener);
                    newValue.rowLimitProperty().addListener(this.weakRowLimitInvalidationListener);
                } else {
                    this.updateContent(Collections.emptyList());
                }
            });
        }

        @Override
        protected void updateItem(CollapsibleOrderbookEntries item, boolean empty) {
            super.updateItem(item, empty);
            OrderbookEntriesCellFactory.this.selectedCellService.update(this);
        }

        private void updateContent(List<CommonOrderbookEntry> entries2) {
            this.newRows.clear();
            this.rowsToRemove.clear();
            if (this.getItem() != null) {
                int row;
                int rowLimitValue = ((CollapsibleOrderbookEntries)this.getItem()).rowLimitProperty().getValue().intValue();
                int effectiveRowLimit = rowLimitValue == -1 ? entries2.size() : rowLimitValue;
                int rowsCurrentlyShown = this.contentContainer.getChildren().size();
                int rowsToShow = Math.min(effectiveRowLimit, entries2.size());
                int rowsToReuse = Math.min(rowsToShow, rowsCurrentlyShown);
                this.newRows.addAll(this.contentContainer.getChildren().subList(0, rowsToReuse));
                for (row = 0; row < rowsToReuse; ++row) {
                    this.applyValue(entries2.get(row), (EntryTextWithFlash)this.newRows.get(row));
                }
                if (rowsToShow > rowsCurrentlyShown) {
                    for (row = rowsToReuse; row < rowsToShow; ++row) {
                        this.newRows.add(this.getEntryNode(entries2.get(row)));
                    }
                } else if (rowsToShow < rowsCurrentlyShown) {
                    for (row = rowsToShow; row < rowsCurrentlyShown; ++row) {
                        this.rowsToRemove.add((Node)this.contentContainer.getChildren().get(row));
                    }
                }
                for (row = 0; row < this.newRows.size(); ++row) {
                    Node node = this.newRows.get(row);
                    OrderbookEntryTableCellClickHandler mouseHandler = new OrderbookEntryTableCellClickHandler(OrderbookEntriesCellFactory.this.appContext, entries2.get(row), (Node)this.contentContainer, OrderbookEntriesCellFactory.this.quantitySelector);
                    node.setOnMouseClicked(mouseHandler);
                    node.setOnDragDetected(mouseHandler);
                    ((EntryTextWithFlash)node).applyStyleClass(row % 2 != 0);
                }
                this.contentContainer.getChildren().setAll((Collection<Node>)this.newRows);
            } else {
                this.rowsToRemove.addAll(this.contentContainer.getChildren());
                this.contentContainer.getChildren().clear();
            }
            if (this.newRows.isEmpty()) {
                ObservableList items = this.getTableView().getItems();
                int rowIndex = this.getIndex();
                OrderbookEntryType orderbookEntryType = rowIndex >= 0 && rowIndex < items.size() ? ((CollapsibleValueOrderbookWrapper)items.get(rowIndex)).getType() : OrderbookEntryType.AGGREGATED;
                this.setOnMouseClicked(event -> OrderbookEntriesCellFactory.this.tradingActionService.doAction((MouseEvent)event, ((CollapsibleOrderbookEntries)this.getItem()).getOrderbook(), ((CollapsibleOrderbookEntries)this.getItem()).getDirection(), orderbookEntryType));
            } else {
                this.setOnMouseClicked(null);
            }
            this.rowsToRemove.stream().map(EntryTextWithFlash.class::cast).map(Labeled::textProperty).forEach(Property::unbind);
        }

        private EntryTextWithFlash getEntryNode(CommonOrderbookEntry entry) {
            EntryTextWithFlash entryTextWithFlash = new EntryTextWithFlash(OrderbookEntriesCellFactory.this.appContext);
            this.applyValue(entry, entryTextWithFlash);
            return entryTextWithFlash;
        }

        private void applyValue(CommonOrderbookEntry entry, EntryTextWithFlash row) {
            String textValue = ((CollapsibleOrderbookEntries)this.getItem()).getDisplayValueFunction().apply(entry).getValue();
            row.abortFlash();
            row.applyValue(entry, textValue);
        }
    }
}

