/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.util;

import com.deutscheboerse.comxerv.comtrader.service.performancemonitoring.FramerateMonitor;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.google.inject.Singleton;
import javafx.animation.AnimationTimer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

@Singleton
public class FxFramerateMonitor
implements FramerateMonitor {
    private static final Logger PERFORMANCE_LOG = LoggerFactory.getLogger("performance");
    private static final Marker FPS_MARKER = MarkerFactory.getMarker("FPS");
    private final AnimationTimer animationTimer = new AnimationTimer(){

        @Override
        public void handle(long now) {
            FxFramerateMonitor.this.handleFrame(now);
        }
    };
    private int frameCount = 0;
    private long currentSecond = 0L;

    private void handleFrame(long now) {
        long second = now / 1000000000L;
        if (second != this.currentSecond) {
            this.currentSecond = second;
            PERFORMANCE_LOG.debug(FPS_MARKER, Integer.toString(this.frameCount));
            this.frameCount = 1;
        } else {
            ++this.frameCount;
        }
    }

    @Override
    public void enable() {
        FxUtil.runInFxThread(this.animationTimer::start);
    }

    @Override
    public void disable() {
        FxUtil.runInFxThread(this.animationTimer::stop);
    }
}

