/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModel;
import com.deutscheboerse.comxerv.comtrader.entities.BalancingGroup;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.MarketArea;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.service.AssignmentService;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Singleton
public class AssignmentServiceImpl
implements AssignmentService {
    private final DataModel<String, BalancingGroup> balancingGroupDataModel;
    private final DataModel<String, DeliveryArea> deliveryAreaDataModel;

    @Inject
    public AssignmentServiceImpl(ApplicationContext applicationContext) {
        this.deliveryAreaDataModel = applicationContext.getDataModel(DeliveryArea.class);
        this.balancingGroupDataModel = applicationContext.getDataModel(BalancingGroup.class);
    }

    @Override
    public boolean isDeliveryAreaAssignedToUser(User user, DeliveryArea deliveryArea) {
        String entityId = (String)deliveryArea.getId();
        return this.getBalancingGroupsForUser(user).flatMap(bg -> bg.getDeliveryAreaIds().stream()).anyMatch(entityId::equals);
    }

    @Override
    public boolean isMarketAreaAssignedToUser(User user, MarketArea marketArea) {
        String entityId = (String)marketArea.getId();
        return this.getBalancingGroupsForUser(user).flatMap(bg -> bg.getDeliveryAreaIds().stream().map(id -> this.deliveryAreaDataModel.findById((String)id).getMarketAreaId())).anyMatch(entityId::equals);
    }

    @Override
    public Set<String> getProductIds(User user) {
        return this.getBalancingGroupsForUser(user).flatMap(bg -> bg.getProductIds().stream()).collect(Collectors.toSet());
    }

    @Override
    public Set<String> getProductIdsForBroker(User broker) {
        Set<String> assignedBgIds = this.getAssignedBgIdsForBroker(broker);
        return this.getBalancingGroupsWithIds(assignedBgIds).flatMap(bg -> bg.getProductIds().stream()).collect(Collectors.toSet());
    }

    @Override
    public Set<String> getProductIdsForBgId(String bgId) {
        return this.getBalancingGroup(bgId).map(BalancingGroup::getProductIds).orElse(Collections.emptySet());
    }

    @Override
    public Set<String> getAssignedBgIdsForBroker(User broker) {
        return this.getAssignedBgIdsForBrokerAsStream(broker).collect(Collectors.toSet());
    }

    private Stream<String> getAssignedBgIdsForBrokerAsStream(User broker) {
        Stream<String> result = this.getBalancingGroupsForUser(broker).flatMap(bg -> bg.getAssignedBgIds().stream());
        if (broker.getRoles().isOwnTrading() || broker.getRoles().isOnBehalf()) {
            return Stream.concat(result, broker.getBalancingGroupIds().stream());
        }
        return result;
    }

    @Override
    public boolean isProductAssignedToUser(String productId, User user) {
        return this.getBalancingGroupsForUser(user).flatMap(bg -> bg.getProductIds().stream()).anyMatch(productId::equals);
    }

    @Override
    public boolean isProductAssignedToBroker(Product product, User broker) {
        return this.getAssignedBgIdsForBrokerAsStream(broker).map(this.balancingGroupDataModel::findById).filter(Objects::nonNull).flatMap(bg -> bg.getProductIds().stream()).anyMatch(((String)product.getId())::equals);
    }

    @Override
    public boolean isProductAssignedToBg(String productId, String bgId) {
        return this.getBalancingGroup(bgId).map(bg -> bg.containsProductId(productId)).orElse(false);
    }

    @Override
    public boolean isUserAssignedToBgAndProduct(User user, String bgId, String productId) {
        return this.isUserAssignedToBg(user, bgId) && this.isProductAssignedToBg(productId, bgId);
    }

    @Override
    public boolean isUserAssignedToBgProductAndDa(User user, String bgId, String productId, String daId) {
        return this.isUserAssignedToBg(user, bgId) && this.isProductAssignedToBg(productId, bgId) && this.isDaAssignedToBg(daId, bgId) && this.isProductAssignedToDa(productId, daId);
    }

    private boolean isUserAssignedToBg(User user, String bgId) {
        return user.containsBalancingGroupId(bgId);
    }

    private boolean isDaAssignedToBg(String daId, String bgId) {
        return this.getBalancingGroup(bgId).map(bg -> bg.containsDeliveryAreaId(daId)).orElse(false);
    }

    private Optional<BalancingGroup> getBalancingGroup(String bgId) {
        return Optional.ofNullable(this.balancingGroupDataModel.findById(bgId));
    }

    private Stream<BalancingGroup> getBalancingGroupsForUser(User user) {
        return this.getBalancingGroupsWithIds(user.getBalancingGroupIds());
    }

    private Stream<BalancingGroup> getBalancingGroupsWithIds(Set<String> ids) {
        return ids.stream().map(this.balancingGroupDataModel::findById).filter(Objects::nonNull);
    }

    private boolean isProductAssignedToDa(String productId, String daId) {
        return Optional.ofNullable(this.deliveryAreaDataModel.findById(daId)).map(da -> da.containsProductId(productId)).orElse(false);
    }
}

