/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service;

import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.rabbitmq.client.PossibleAuthenticationFailureException;
import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.concurrent.TimeoutException;
import org.apache.http.impl.execchain.TunnelRefusedException;

public class LoginException
extends Exception {
    private ErrorType errorType;

    public LoginException(String message) {
        this(message, ErrorType.OTHER);
    }

    public LoginException(String message, Throwable cause) {
        this(message, ErrorType.OTHER, cause);
    }

    public LoginException(String message, ErrorType errorType) {
        super(message);
        this.errorType = errorType;
    }

    public LoginException(String message, ErrorType errorType, Throwable cause) {
        super(message, cause);
        this.errorType = errorType;
    }

    public static LoginException fromTimeoutException(TimeoutException e) {
        return new LoginException(Util.getLabel("login_exception_timeout"), ErrorType.INFRASTRUCTURE_ERROR, e);
    }

    public static LoginException fromIOException(IOException e) {
        String message = e.getMessage();
        if (e instanceof PossibleAuthenticationFailureException) {
            return new LoginException(Util.getLabel("login_exception_invalid_username_or_password"), ErrorType.AUTHENTICATION_FAILURE, e);
        }
        if (e instanceof UnknownHostException) {
            return new LoginException(Util.getLabel("login_exception_unknown_host", message), ErrorType.INFRASTRUCTURE_ERROR, e);
        }
        if (e instanceof SocketException) {
            return new LoginException(Util.getLabel("login_exception_network_error", message), ErrorType.INFRASTRUCTURE_ERROR, e);
        }
        if (message != null && message.contains("Delivery failed")) {
            return new LoginException(Util.getLabel("login_exception_server_down"), ErrorType.INFRASTRUCTURE_ERROR, e);
        }
        if (message != null && message.contains("Proxy Authentication Required")) {
            return new LoginException(Util.getLabel("login_exception_proxy_auth_required"), ErrorType.INFRASTRUCTURE_ERROR, e);
        }
        if (e.getCause() instanceof TunnelRefusedException) {
            TunnelRefusedException tre = (TunnelRefusedException)e.getCause();
            return new LoginException(Util.getLabel("login_exception_proxy_refusing", tre.getResponse().getStatusLine().toString()), ErrorType.INFRASTRUCTURE_ERROR, e);
        }
        return new LoginException(Util.getLabel("login_exception_unknown_infr_error", message != null && !message.isEmpty() ? message : e.getClass().getSimpleName()), ErrorType.INFRASTRUCTURE_ERROR, e);
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public static enum ErrorType {
        AUTHENTICATION_FAILURE,
        INFRASTRUCTURE_ERROR,
        SSL_CERTIFICATE_ERROR,
        EULA_NOT_ACCEPTED,
        OTHER;

    }
}

