/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class NamedParameterMessageFormat {
    private static Cache<String, ParsedMessagePattern> parsedMessageFormatCache = CacheBuilder.newBuilder().maximumSize(256L).build();
    private final String pattern;

    public NamedParameterMessageFormat(String pattern) {
        this.pattern = pattern;
    }

    private static ParsedMessagePattern getParsedMessagePattern(String format) {
        ParsedMessagePattern parsedPattern = parsedMessageFormatCache.getIfPresent(format);
        if (parsedPattern == null) {
            parsedPattern = NamedParameterMessageFormat.parseMessageFormat(format);
            parsedMessageFormatCache.put(format, parsedPattern);
        }
        return parsedPattern;
    }

    private static ParsedMessagePattern parseMessageFormat(String toParse) {
        char[] format = toParse.toCharArray();
        ParsedMessagePattern parsedMessagePattern = new ParsedMessagePattern(toParse);
        for (int i = 0; i < format.length; ++i) {
            if (format[i] != '{') continue;
            int j = i + 1;
            while (j < format.length && format[j] != '}' && format[j] != ',') {
                if (format[++j] != '{') continue;
                throw new IllegalArgumentException("Unbalanced braces");
            }
            if (j - i > 1) {
                String parameterName = toParse.substring(i + 1, j);
                parsedMessagePattern.addParameter(parameterName, i + 1, j);
            }
            i = j - 1;
        }
        return parsedMessagePattern;
    }

    private static String substituteNamedParameters(ParsedMessagePattern pattern, Map<String, Object> parameters) {
        String originalPattern = pattern.getOriginalPattern();
        List<ParameterHolder> parameterHolders = pattern.getParameters();
        StringBuilder actualPattern = new StringBuilder();
        int lastIndex = 0;
        int paramIndex = 0;
        for (ParameterHolder parameterHolder : parameterHolders) {
            int startIndex = parameterHolder.startIndex;
            int endIndex = parameterHolder.endIndex;
            actualPattern.append(originalPattern.substring(lastIndex, startIndex));
            if (parameters != null && parameters.containsKey(parameterHolder.parameterName)) {
                actualPattern.append(paramIndex);
                ++paramIndex;
            }
            lastIndex = endIndex;
        }
        actualPattern.append(originalPattern.substring(lastIndex, originalPattern.length()));
        return actualPattern.toString();
    }

    private static Object[] buildValueArray(ParsedMessagePattern parsedMessagePattern, Map<String, Object> parameters) {
        List<ParameterHolder> parameterHolders = parsedMessagePattern.getParameters();
        Object[] params = new Object[parameterHolders.size()];
        for (int i = 0; i < params.length; ++i) {
            params[i] = parameters.get(parameterHolders.get(i).getParameterName());
        }
        return params;
    }

    public static String format(String format, Map<String, Object> map) {
        return new NamedParameterMessageFormat(format).format(map);
    }

    public String format(Map<String, Object> parameters) {
        return this.format(Locale.getDefault(Locale.Category.FORMAT), parameters);
    }

    public String format(Locale locale, Map<String, Object> parameters) {
        ParsedMessagePattern parsedMessagePattern = NamedParameterMessageFormat.getParsedMessagePattern(this.pattern);
        String patternToUse = NamedParameterMessageFormat.substituteNamedParameters(parsedMessagePattern, parameters);
        Object[] params = NamedParameterMessageFormat.buildValueArray(parsedMessagePattern, parameters);
        if (locale == null) {
            return MessageFormat.format(patternToUse, params);
        }
        MessageFormat messageFormat = new MessageFormat(patternToUse, locale);
        return messageFormat.format(params);
    }

    private static class ParsedMessagePattern {
        private List<ParameterHolder> parameters = new ArrayList<ParameterHolder>();
        private String originalPattern;

        public ParsedMessagePattern(String originalPattern) {
            this.originalPattern = originalPattern;
        }

        public void addParameter(String name, int startIndex, int endIndex) {
            this.parameters.add(new ParameterHolder(name, startIndex, endIndex));
        }

        public String getOriginalPattern() {
            return this.originalPattern;
        }

        public List<ParameterHolder> getParameters() {
            return this.parameters;
        }
    }

    private static class ParameterHolder {
        private String parameterName;
        private int startIndex;
        private int endIndex;

        public ParameterHolder(String parameterName, int startIndex, int endIndex) {
            this.parameterName = parameterName;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }

        public String getParameterName() {
            return this.parameterName;
        }
    }
}

