/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.AbstractDataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModel;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModelListener;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderType;
import com.deutscheboerse.comxerv.comtrader.service.AssignmentService;
import com.deutscheboerse.comxerv.comtrader.service.OwnQuantityLookupService;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

@Singleton
public class OwnQuantityLookupServiceImpl
implements OwnQuantityLookupService {
    private final UserService userService;
    private final DataModel<Long, Order> orderDataModel;
    private final AssignmentService assignmentService;
    private static final long EXPIRE_TIME_IN_MINUTES = 15L;
    private static final long MAXIMUM_SIZE = 5000L;
    private final Cache<Long, Order> removedOrdersCahe;

    @Inject
    public OwnQuantityLookupServiceImpl(ApplicationContext appContext) {
        this.userService = appContext.getService(UserService.class);
        this.removedOrdersCahe = CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.MINUTES).maximumSize(5000L).build();
        this.orderDataModel = appContext.getDataModel(Order.class);
        this.orderDataModel.registerHencePreOperationListener(new CacheMaintainer(this.removedOrdersCahe));
        this.assignmentService = appContext.getService(AssignmentService.class);
    }

    @Override
    public boolean isOwnOrder(Long orderId) {
        Order order = this.findOrderById(orderId);
        return order != null && this.isOwnOrder(order);
    }

    @Override
    public boolean isOwnUserOrder(Long orderId) {
        Order order = this.findOrderById(orderId);
        return order != null && this.userService.getCurrentUser().equals(order.getUser());
    }

    @Override
    public boolean isOwnOrder(Order order) {
        User user = this.userService.getCurrentUser();
        return user != null && this.isOwnOrder(order, user);
    }

    @Override
    public boolean isOwnUserOrder(Order order) {
        User user = this.userService.getCurrentUser();
        return user != null && user.equals(order.getUser());
    }

    private boolean isOwnOrder(Order order, User user) {
        return this.hasPermissions(order, user) || order.getOrderType() == OrderType.OTC_PREARRANGED && this.prearrangedHasPermission(order, user);
    }

    private boolean hasPermissions(Order order, User user) {
        return order.getBalancingGroup() != null && order.getContract() != null && order.getDeliveryArea() != null && this.assignmentService.isUserAssignedToBgProductAndDa(user, (String)order.getBalancingGroup().getId(), (String)order.getContract().getProduct().getId(), (String)order.getDeliveryArea().getId());
    }

    private boolean prearrangedHasPermission(Order order, User user) {
        return order.getPreArrangedBalancingGroup() != null && order.getContract() != null && this.assignmentService.isUserAssignedToBgAndProduct(user, (String)order.getPreArrangedBalancingGroup().getId(), (String)order.getContract().getProduct().getId());
    }

    private Order findOrderById(Long orderId) {
        return Optional.ofNullable(this.orderDataModel.findById(orderId)).orElseGet(() -> this.removedOrdersCahe.getIfPresent(orderId));
    }

    protected Cache<Long, Order> getRemovedOrdersCahe() {
        return this.removedOrdersCahe;
    }

    private static final class CacheMaintainer
    extends AbstractDataModelListener<Order>
    implements DataModelListener<Order> {
        private final Cache<Long, Order> cache;

        public CacheMaintainer(Cache<Long, Order> cache) {
            this.cache = cache;
        }

        @Override
        public DataModelListener.NotificationResult notifyRemove(Order object) {
            this.cache.put((Long)object.getId(), object);
            return DataModelListener.NotificationResult.RETAIN_LISTENER;
        }

        @Override
        public DataModelListener.NotificationResult notifyRemoveAll(Collection<Order> objects) {
            objects.stream().forEach(order -> this.cache.put((Long)order.getId(), (Order)order));
            return DataModelListener.NotificationResult.RETAIN_LISTENER;
        }

        @Override
        public DataModelListener.NotificationResult notifyRemoveAll() {
            this.cache.asMap().keySet().clear();
            return DataModelListener.NotificationResult.RETAIN_LISTENER;
        }
    }
}

