/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service;

import com.deutscheboerse.comxerv.comtrader.core.ActiveExchange;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.EntityListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.SmallFastDataModel;
import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.domain.query.PublicTradeConfirmationQueries;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.FullTrade;
import com.deutscheboerse.comxerv.comtrader.entities.HalfTrade;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.MarketState;
import com.deutscheboerse.comxerv.comtrader.entities.Message;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.PublicTradeConfirmation;
import com.deutscheboerse.comxerv.comtrader.entities.StatusMessageType;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.entities.comxerv.OrderQuoteNotification;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.entities.type.ContractPhase;
import com.deutscheboerse.comxerv.comtrader.entities.type.ContractStatus;
import com.deutscheboerse.comxerv.comtrader.entities.type.ExecutionRestriction;
import com.deutscheboerse.comxerv.comtrader.entities.type.MarketStatus;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderType;
import com.deutscheboerse.comxerv.comtrader.entities.type.SpecialMessage;
import com.deutscheboerse.comxerv.comtrader.entities.type.SuspensionType;
import com.deutscheboerse.comxerv.comtrader.entities.type.TradeState;
import com.deutscheboerse.comxerv.comtrader.entities.type.TradeType;
import com.deutscheboerse.comxerv.comtrader.service.BroadcastListenerHandlerForClass;
import com.deutscheboerse.comxerv.comtrader.service.StatusMessageBuilder;
import com.deutscheboerse.comxerv.comtrader.service.StatusMessageService;
import com.deutscheboerse.comxerv.comtrader.service.UserAlertService;
import com.deutscheboerse.comxerv.comtrader.service.event.LoginEvent;
import com.deutscheboerse.comxerv.comtrader.service.time.TimeService;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusMessageServiceImpl
implements StatusMessageService {
    private static final Logger LOG = LoggerFactory.getLogger(StatusMessageServiceImpl.class);
    private final ActiveExchange activeExchange;
    private final SmallFastDataModel<String, Message> messageDataModel;
    private final SmallFastDataModel<Long, Order> orderDataModel;
    private final TimeService timeService;
    private final UserService userService;
    private final ApplicationContext applicationContext;
    private final AtomicLong seqNumber;
    private final SmallFastDataModel<Long, Contract> contractDataModel;
    private final PublicTradeConfirmationQueries publicTradeConfirmationQueries;
    private final Set<String> stopOrderConvertedClientOrderIds;
    private HalfTrade lastHalfTrade;
    private String lastDeliveryAreaChangeCorrelationId;
    private String lastMarketChangeCorrelationId;
    private StatusMessageTranslator<User> userTranslator = new StatusMessageTranslator<User>(User.class, this::createLoginMessage);

    @Inject
    public StatusMessageServiceImpl(ApplicationContext applicationContext) {
        BroadcastListenerHandlerForClass listenerHandlerForClass = applicationContext.getService(BroadcastListenerHandlerForClass.class);
        listenerHandlerForClass.registerBackendBroadcastListener(new StatusMessageTranslator<Order>(Order.class, this::createOrderMessage));
        listenerHandlerForClass.registerBackendBroadcastListener(new StatusMessageTranslator<OrderQuoteNotification>(OrderQuoteNotification.class, this::createQuoteMessage));
        listenerHandlerForClass.registerBackendBroadcastListener(new StatusMessageTranslator<PublicTradeConfirmation>(PublicTradeConfirmation.class, this::createTradeMessage));
        listenerHandlerForClass.registerBackendBroadcastListener(new StatusMessageTranslator<FullTrade>(FullTrade.class, this::createTradeMessage));
        listenerHandlerForClass.registerBackendBroadcastListener(new StatusMessageTranslator<MarketState>(MarketState.class, this::createMarketStateMessage));
        listenerHandlerForClass.registerBackendBroadcastListener(new StatusMessageTranslator<Contract>(Contract.class, this::createContractMessage));
        listenerHandlerForClass.registerBackendBroadcastListener(new StatusMessageTranslator<DeliveryArea>(DeliveryArea.class, this::createDeliveryAreaMessage));
        listenerHandlerForClass.registerBackendBroadcastListener(new StatusMessageTranslator<Orderbook>(Orderbook.class, this::createOrderbookMessage));
        this.activeExchange = applicationContext.getService(ActiveExchange.class);
        this.messageDataModel = applicationContext.getSmallDataModel(Message.class);
        this.orderDataModel = applicationContext.getSmallDataModel(Order.class);
        this.contractDataModel = applicationContext.getSmallDataModel(Contract.class);
        this.timeService = applicationContext.getService(TimeService.class);
        this.applicationContext = applicationContext;
        this.seqNumber = new AtomicLong(0L);
        this.applicationContext.getService(EventBus.class).register(this);
        this.userService = applicationContext.getService(UserService.class);
        this.publicTradeConfirmationQueries = applicationContext.getService(PublicTradeConfirmationQueries.class);
        this.stopOrderConvertedClientOrderIds = ConcurrentHashMap.newKeySet();
    }

    private void createOrderMessage(Order order, Consumer<StatusMessageBuilder> consumer) {
        StatusMessageType statusMessageType;
        if (this.lastDeliveryAreaChangeCorrelationId != null && this.lastDeliveryAreaChangeCorrelationId.equals(order.getCorrelationId())) {
            LOG.debug("Not showing messages for order {} caused by delivery area status change.", order.getId());
            return;
        }
        Order oldOrder = (Order)this.orderDataModel.findById((Long)order.getId());
        if (oldOrder != null && order.getLastUpdateTimeStamp().equals(oldOrder.getLastUpdateTimeStamp()) && order.getModificationType() == oldOrder.getModificationType()) {
            LOG.debug("Not showing message for duplicated OrdrExeRrpt: {}", (Object)order);
            return;
        }
        switch (order.getModificationType()) {
            case USER_ADD: {
                statusMessageType = this.getStatusMessageTypeForOrderAddedByUser(order);
                break;
            }
            case QUOTE_ADD: {
                if (order.getOrderType() == OrderType.QUOTE_INDICATIVE) {
                    statusMessageType = StatusMessageType.MSG_QUOTE_INDICATIVE_ENTERED;
                    break;
                }
                statusMessageType = StatusMessageType.MSG_QUOTE_ENTERED;
                break;
            }
            case ADMIN_ADD: {
                if (order.getOrderType() == OrderType.OTC_PREARRANGED) {
                    statusMessageType = StatusMessageType.MSG_ORDER_ENTERED_PREARRANGED_ON_BEHALF_ADMIN;
                    break;
                }
                statusMessageType = StatusMessageType.MSG_ORDER_ON_BEHALF_ENTERED_ADMIN;
                break;
            }
            case SYSTEM_ADD: {
                if (oldOrder != null && oldOrder.getOrderType() == OrderType.STOP && order.getOrderType() == OrderType.REGULAR) {
                    statusMessageType = StatusMessageType.MSG_ORDER_TRIGGERED;
                    break;
                }
                return;
            }
            case USER_DELETE: {
                statusMessageType = this.getStatusMessageTypeForOrderDeletedByUser(order);
                break;
            }
            case SYSTEM_DELETE: {
                statusMessageType = StatusMessageType.MSG_ORDER_DELETED;
                break;
            }
            case ADMIN_DELETE: {
                if (order.getOrderType() == OrderType.OTC_PREARRANGED) {
                    statusMessageType = StatusMessageType.MSG_ORDER_DELETED_PREARRANGED_ON_BEHALF_ADMIN;
                    break;
                }
                statusMessageType = StatusMessageType.MSG_ORDER_ON_BEHALF_DELETED_ADMIN;
                break;
            }
            case USER_MODIFICATION: {
                statusMessageType = this.getStatusMessageTypeForOrderModifiedByUser(order);
                break;
            }
            case ADMIN_MODIFICATION: {
                if (order.getOrderType() == OrderType.OTC_PREARRANGED) {
                    statusMessageType = StatusMessageType.MSG_ORDER_MODIFIED_PREARRANGED_ON_BEHALF_ADMIN;
                    break;
                }
                statusMessageType = StatusMessageType.MSG_ORDER_ON_BEHALF_MODIFIED_ADMIN;
                break;
            }
            case USER_HIBERNATE: {
                statusMessageType = this.pickOrderMessage(order, StatusMessageType.MSG_ORDER_ON_BEHALF_INACTIVATE_ADMIN, StatusMessageType.MSG_ORDER_ON_BEHALF_INACTIVATE_USER, StatusMessageType.MSG_ORDER_INACTIVATE);
                break;
            }
            case ADMIN_HIBERNATE: {
                statusMessageType = StatusMessageType.MSG_ORDER_ON_BEHALF_INACTIVATE_ADMIN;
                break;
            }
            case USER_REJECT: {
                if (order.getBrokerUserId() != null) {
                    if (this.isCurrentUserAdmin()) {
                        statusMessageType = StatusMessageType.MSG_ORDER_REJECTED_BEHALF_ADMIN;
                        break;
                    }
                    if (this.isMyOrder(order)) {
                        statusMessageType = StatusMessageType.MSG_ORDER_REJECTED_BEHALF_TARGET;
                        break;
                    }
                    statusMessageType = StatusMessageType.MSG_ORDER_REJECTED_BEHALF_ORIGINATOR;
                    break;
                }
                statusMessageType = StatusMessageType.MSG_ORDER_REJECTED;
                break;
            }
            case ORDER_PARTIALLY_EXECUTED: {
                if (order.getExecutionRestriction() == ExecutionRestriction.IMMEDIATE_OR_CANCEL) {
                    statusMessageType = StatusMessageType.MSG_ORDER_EXECUTED_PARTIAL_DELETED;
                    break;
                }
                statusMessageType = StatusMessageType.MSG_ORDER_EXECUTED_PARTIAL;
                break;
            }
            case QUOTE_PARTIALLY_EXECUTED: {
                statusMessageType = StatusMessageType.MSG_QUOTE_EXECUTED_PARTIAL;
                break;
            }
            case ORDER_FULLY_EXECUTED: {
                statusMessageType = this.getStatusMessageTypeForOrderExecutedFully(order);
                break;
            }
            case QUOTE_FULLY_EXECUTED: {
                statusMessageType = StatusMessageType.MSG_QUOTE_EXECUTED;
                break;
            }
            default: {
                return;
            }
        }
        if (statusMessageType != null) {
            consumer.accept(StatusMessageBuilder.publicMessage(statusMessageType).with(oldOrder, order).with(this.userService.getOwnUser()).withOnBehalf(order.getLastUpdateUser()));
        }
        if (order.getClientOrderId() != null && this.stopOrderConvertedClientOrderIds.remove(order.getClientOrderId()) && (statusMessageType == StatusMessageType.MSG_ORDER_ENTERED || statusMessageType == StatusMessageType.MSG_ORDER_ENTERED_PREARRANGED_ON_BEHALF_USER) && order.getOrderType() != OrderType.STOP) {
            consumer.accept(StatusMessageBuilder.publicMessage(StatusMessageType.MSG_STOP_ORDER_CONVERTED).with(oldOrder, order));
        }
    }

    private StatusMessageType getStatusMessageTypeForOrderAddedByUser(Order order) {
        if (order.getOrderType() == OrderType.OTC_PREARRANGED && this.userService.getCurrentUser().containsBalancingGroupId(order.getPreArrangedBalancingGroupId())) {
            return StatusMessageType.MSG_ORDER_RECEIVED_PREARRANGED;
        }
        if (order.getOrderType() == OrderType.OTC_PREARRANGED) {
            return this.pickOrderMessage(order, StatusMessageType.MSG_ORDER_ENTERED_PREARRANGED_ON_BEHALF_ADMIN, StatusMessageType.MSG_ORDER_ENTERED_PREARRANGED_ON_BEHALF_USER, StatusMessageType.MSG_ORDER_ENTERED_PREARRANGED);
        }
        return this.pickOrderMessage(order, StatusMessageType.MSG_ORDER_ON_BEHALF_ENTERED_ADMIN, StatusMessageType.MSG_ORDER_ON_BEHALF_ENTERED_USER, StatusMessageType.MSG_ORDER_ENTERED);
    }

    private StatusMessageType getStatusMessageTypeForOrderDeletedByUser(Order order) {
        if (order.getOrderType() == OrderType.OTC_PREARRANGED && this.isOrderPrearrangedForMe(order)) {
            return StatusMessageType.MSG_ORDER_REVOKED_PREARRANGED;
        }
        if (order.getOrderType() == OrderType.OTC_PREARRANGED) {
            return this.pickOrderMessage(order, StatusMessageType.MSG_ORDER_DELETED_PREARRANGED_ON_BEHALF_ADMIN, StatusMessageType.MSG_ORDER_DELETED_PREARRANGED_ON_BEHALF_USER, StatusMessageType.MSG_ORDER_DELETED_PREARRANGED);
        }
        return this.pickOrderMessage(order, StatusMessageType.MSG_ORDER_ON_BEHALF_DELETED_ADMIN, StatusMessageType.MSG_ORDER_ON_BEHALF_DELETED_USER, StatusMessageType.MSG_ORDER_DELETED);
    }

    private StatusMessageType getStatusMessageTypeForOrderModifiedByUser(Order order) {
        if (order.getOrderType() == OrderType.OTC_PREARRANGED) {
            return this.pickOrderMessage(order, StatusMessageType.MSG_ORDER_MODIFIED_PREARRANGED_ON_BEHALF_ADMIN, StatusMessageType.MSG_ORDER_MODIFIED_PREARRANGED_ON_BEHALF_USER, StatusMessageType.MSG_ORDER_MODIFIED_PREARRANGED);
        }
        return this.pickOrderMessage(order, StatusMessageType.MSG_ORDER_ON_BEHALF_MODIFIED_ADMIN, StatusMessageType.MSG_ORDER_ON_BEHALF_MODIFIED_USER, StatusMessageType.MSG_ORDER_MODIFIED);
    }

    private StatusMessageType getStatusMessageTypeForOrderExecutedFully(Order order) {
        if (order.getOrderType() == OrderType.OTC_PREARRANGED) {
            if (order.getBrokerUserId() != null) {
                if (this.isMyOrder(order)) {
                    return StatusMessageType.MSG_ORDER_ACCEPTED_BEHALF_TRADER;
                }
                return StatusMessageType.MSG_ORDER_ACCEPTED_BEHALF_ORIGINATOR;
            }
            if (this.isMyOrder(order)) {
                return StatusMessageType.MSG_ORDER_ACCEPTED;
            }
            return null;
        }
        return StatusMessageType.MSG_ORDER_EXECUTED;
    }

    private StatusMessageType pickOrderMessage(Order order, StatusMessageType onBehalfAdminMessage, StatusMessageType onBehalfUserMessage, StatusMessageType regularMessage) {
        if (order.getOnBehalfUser() != null) {
            if (this.isCurrentUserAdmin()) {
                return onBehalfAdminMessage;
            }
            return onBehalfUserMessage;
        }
        return regularMessage;
    }

    private void createTradeMessage(PublicTradeConfirmation publicTradeConfirmation, Consumer<StatusMessageBuilder> consumer) {
        StatusMessageType statusMessageType;
        if (publicTradeConfirmation.getTradeExecutionTime().isBefore(this.applicationContext.getService(TimeService.class).getServerTime().minusHours(1))) {
            return;
        }
        SpecialMessage specialMessage = null;
        switch (publicTradeConfirmation.getState()) {
            case ACTIVE: {
                if (publicTradeConfirmation.isSelfTrade()) {
                    statusMessageType = StatusMessageType.MSG_SELF_TRADE_PUBLIC;
                    break;
                }
                statusMessageType = StatusMessageType.MSG_TRADE_PUBLIC;
                break;
            }
            case CANCELLED: {
                statusMessageType = StatusMessageType.MSG_TRADE_CANCELLED_PUBLIC;
                break;
            }
            case RECALL_REQUESTED: {
                statusMessageType = this.getRecallMessageType(publicTradeConfirmation);
                break;
            }
            case RECALL_GRANTED: {
                statusMessageType = StatusMessageType.MSG_TRADE_PUBLIC_RECALL_ACCEPTED;
                break;
            }
            case RECALL_REJECTED: {
                statusMessageType = StatusMessageType.MSG_TRADE_PUBLIC_RECALL_REJECTED;
                break;
            }
            default: {
                return;
            }
        }
        if (StatusMessageType.MSG_ADMIN_RECALL_TRADE_ONBEHALF.equals((Object)statusMessageType)) {
            specialMessage = SpecialMessage.TRADE_RECALL_REQUESTED;
        }
        consumer.accept(StatusMessageBuilder.publicMessage(statusMessageType).with(publicTradeConfirmation).withSpecialMessage(specialMessage));
    }

    private StatusMessageType getRecallMessageType(PublicTradeConfirmation publicTradeConfirmation) {
        if (this.isLoggedInUserAdmin()) {
            return publicTradeConfirmation.isOnBehalf() ? StatusMessageType.MSG_ADMIN_RECALL_TRADE_ONBEHALF : StatusMessageType.MSG_ADMIN_RECALL_TRADE;
        }
        return StatusMessageType.MSG_TRADE_RECALL_PUBLIC;
    }

    private void createQuoteMessage(OrderQuoteNotification quote, Consumer<StatusMessageBuilder> consumer) {
        consumer.accept(StatusMessageBuilder.publicMessage(StatusMessageType.MSG_QUOTE_REQUEST_FOR_MA).with(quote));
    }

    private void createTradeMessage(FullTrade fullTrade, Consumer<StatusMessageBuilder> consumer) {
        fullTrade.updatedHalfTrades().forEach(halfTrade -> this.createTradeMessage((HalfTrade)halfTrade, consumer));
    }

    private void createTradeMessage(HalfTrade halfTrade, Consumer<StatusMessageBuilder> consumer) {
        if (halfTrade.getTradeType() == TradeType.PREARRANGED && halfTrade.getTradeState() == TradeState.ACTIVE && !this.isLastHalfTradeDuplicate(halfTrade)) {
            consumer.accept(StatusMessageBuilder.publicMessage(StatusMessageType.MSG_TRADE_PUBLIC_PREARRANGED).with(halfTrade));
        } else if (halfTrade.getTradeState() == TradeState.RECALL_GRANTED && !this.isLastHalfTradeDuplicate(halfTrade)) {
            StatusMessageBuilder msg = StatusMessageBuilder.publicMessage(StatusMessageType.MSG_TRADE_RECALL_ACCEPTED).with(halfTrade);
            consumer.accept(msg);
            this.applicationContext.getService(UserAlertService.class).showConfirmationDialog(Util.getLabel("TRADE_RECALL_ACCEPT_SUCCESS"), msg.build(), new UserAlertService.Flag[0]);
        } else if (halfTrade.getTradeState() == TradeState.RECALL_REQUESTED && this.isMyTrade(halfTrade)) {
            consumer.accept(StatusMessageBuilder.publicMessage(StatusMessageType.MSG_TRADE_RECALL).with(halfTrade));
        } else if (halfTrade.getTradeState() == TradeState.RECALL_REQUESTED && this.isLoggedInUserAdmin() && !this.isLastHalfTradeDuplicate(halfTrade)) {
            consumer.accept(StatusMessageBuilder.publicMessage(StatusMessageType.MSG_ADMIN_RECALL_TRADE).with(halfTrade).withSpecialMessage(SpecialMessage.TRADE_RECALL_REQUESTED));
        } else if (halfTrade.getTradeState() == TradeState.RECALL_REJECTED && this.isMyTrade(halfTrade)) {
            StatusMessageBuilder msg = StatusMessageBuilder.publicMessage(StatusMessageType.MSG_TRADE_RECALL_REJECTED).with(halfTrade);
            consumer.accept(msg);
            this.applicationContext.getService(UserAlertService.class).showConfirmationDialog(Util.getLabel("TRADE_RECALL_REJECT_SUCCESS"), msg.build(), new UserAlertService.Flag[0]);
        } else if (halfTrade.getTradeState() == TradeState.CANCELLED && this.isMyTrade(halfTrade)) {
            consumer.accept(StatusMessageBuilder.publicMessage(StatusMessageType.MSG_TRADE_CANCELLED_PRIVATE_TRADER).with(halfTrade).withSpecialMessage(SpecialMessage.TRADE_CANCELLED));
        } else if (halfTrade.getTradeState() == TradeState.CANCELLED && this.isLoggedInUserAdmin()) {
            consumer.accept(StatusMessageBuilder.publicMessage(StatusMessageType.MSG_TRADE_CANCELLED_PRIVATE_ADMIN).with(halfTrade).withSpecialMessage(SpecialMessage.TRADE_CANCELLED));
        }
    }

    private boolean isLastHalfTradeDuplicate(HalfTrade halfTrade) {
        if (this.lastHalfTrade != null && this.lastHalfTrade.getTradeId().equals(halfTrade.getTradeId()) && this.lastHalfTrade.getTimeStamp().equals(halfTrade.getTimeStamp())) {
            LOG.debug("Not showing message for duplicated half trade: {}", (Object)halfTrade);
            return true;
        }
        this.lastHalfTrade = halfTrade;
        return false;
    }

    private void createMarketStateMessage(MarketState marketState, Consumer<StatusMessageBuilder> consumer) {
        this.lastMarketChangeCorrelationId = marketState.getCorrelationId();
        if (marketState.getStatus() == MarketStatus.ACTIVE) {
            consumer.accept(StatusMessageBuilder.publicMessage(StatusMessageType.MSG_MARKET_GO));
        } else if (marketState.getStatus() == MarketStatus.HIBERNATE) {
            consumer.accept(StatusMessageBuilder.publicMessage(StatusMessageType.MSG_MARKET_HALT));
        }
    }

    private void createDeliveryAreaMessage(DeliveryArea deliveryArea, Consumer<StatusMessageBuilder> consumer) {
        this.lastDeliveryAreaChangeCorrelationId = deliveryArea.getCorrelationId();
        if (deliveryArea.getStatus() == SuspensionType.SUSPEND) {
            consumer.accept(StatusMessageBuilder.publicMessage(StatusMessageType.MSG_TSO_HALT).with(deliveryArea));
        } else if (deliveryArea.getStatus() == SuspensionType.ACTIVE) {
            consumer.accept(StatusMessageBuilder.publicMessage(StatusMessageType.MSG_TSO_GO).with(deliveryArea));
        }
    }

    private void createContractMessage(Contract contract, Consumer<StatusMessageBuilder> consumer) {
        List<DeliveryArea> tradingPhaseDeliveryAreasDelta;
        List<DeliveryArea> contDADelta;
        List<DeliveryArea> actiDeliveryAreasDelta;
        if (this.lastDeliveryAreaChangeCorrelationId != null && this.lastDeliveryAreaChangeCorrelationId.equals(contract.getCorrelationId())) {
            LOG.debug("Not showing messages for contract {} caused by delivery area status change.", (Object)contract.getLongName());
            return;
        }
        if (this.lastMarketChangeCorrelationId != null && this.lastMarketChangeCorrelationId.equals(contract.getCorrelationId())) {
            LOG.debug("Not showing messages for contract {} caused by market status change.", (Object)contract.getLongName());
            return;
        }
        Contract oldContract = (Contract)this.contractDataModel.findById((Long)contract.getId());
        List<DeliveryArea> iactDeliveryAreasDelta = this.getDeliveryAreasDelta(oldContract, contract, ContractStatus.IACT);
        if (oldContract != null && contract.getCompoundStatus().getContractStatus() == ContractStatus.IACT) {
            consumer.accept(StatusMessageBuilder.publicMessage(StatusMessageType.MSG_CONTRACT_CLOSED).with(contract));
        } else if (iactDeliveryAreasDelta != null && !iactDeliveryAreasDelta.isEmpty()) {
            consumer.accept(StatusMessageBuilder.publicMessage(StatusMessageType.MSG_CONTRACT_CLOSED_TSOS).with(contract).with(iactDeliveryAreasDelta));
        }
        List<DeliveryArea> hibeDeliveryAreasDelta = this.getDeliveryAreasDelta(oldContract, contract, ContractStatus.HIBE);
        if (hibeDeliveryAreasDelta != null && !hibeDeliveryAreasDelta.isEmpty()) {
            consumer.accept(StatusMessageBuilder.publicMessage(StatusMessageType.MSG_CONTRACT_HIBERNATED).with(contract).with(hibeDeliveryAreasDelta));
        }
        if ((actiDeliveryAreasDelta = this.getDeliveryAreasDelta(oldContract, contract, ContractStatus.ACTI)) != null && !actiDeliveryAreasDelta.isEmpty()) {
            consumer.accept(StatusMessageBuilder.publicMessage(StatusMessageType.MSG_CONTRACT_ACTIVATED).with(contract).with(actiDeliveryAreasDelta));
        }
        if (contract.getCompoundStatus().getContractStatus() == ContractStatus.ACTI && !(contDADelta = this.getDeliveryAreasDelta(oldContract, contract, ContractPhase.CLSD)).isEmpty()) {
            consumer.accept(StatusMessageBuilder.publicMessage(StatusMessageType.MSG_CONTRACT_HIBERNATED).with(contract).with(contDADelta));
        }
        if ((tradingPhaseDeliveryAreasDelta = this.getTradingPhaseDeliveryAreasDelta(oldContract, contract)) != null && !tradingPhaseDeliveryAreasDelta.isEmpty()) {
            for (DeliveryArea deliveryArea : tradingPhaseDeliveryAreasDelta) {
                consumer.accept(StatusMessageBuilder.publicMessage(StatusMessageType.MSG_CONTRACT_MODIFIED).with(Util.getLabel("commons_trading")).with(deliveryArea).with(contract).with(contract.getCompoundStatus().getActivePeriod(deliveryArea)));
            }
        } else if (!(oldContract == null || oldContract.getActivationPoint().equals(contract.getActivationPoint()) && oldContract.getExpiryPoint().equals(contract.getExpiryPoint()))) {
            consumer.accept(StatusMessageBuilder.publicMessage(StatusMessageType.MSG_CONTRACT_MODIFIED_WITHOUT_PHASES).with(contract).with(new Interval((ReadableInstant)contract.getActivationPoint(), (ReadableInstant)contract.getExpiryPoint())));
        }
        if (oldContract != null && ContractPhase.AUCT.equals(oldContract.getCompoundStatus().getTradingPhase()) && ContractPhase.CLSD.equals(contract.getCompoundStatus().getTradingPhase())) {
            PublicTradeConfirmation lastTradeConfirmationForContract = this.publicTradeConfirmationQueries.findNewestTradeConfirmationForContract(contract);
            if (lastTradeConfirmationForContract != null) {
                consumer.accept(StatusMessageBuilder.publicMessage(StatusMessageType.MSG_AUCTION_FINISHED).with(lastTradeConfirmationForContract));
            } else {
                consumer.accept(StatusMessageBuilder.publicMessage(StatusMessageType.MSG_AUCTION_FINISHED_NO_TRADE).with(contract).withQuantity(LongDisplayValue.ZERO.applyShift(contract.getProduct().getQuantityDecimalShift())));
            }
        }
    }

    private void createOrderbookMessage(Orderbook orderbook, Consumer<StatusMessageBuilder> consumer) {
        if (orderbook.getClosingPrice() != null && orderbook.getClosingPriceDate() != null) {
            consumer.accept(StatusMessageBuilder.publicMessage(StatusMessageType.MSG_CONTRACT_CLOSING_REFERENCE_PRICE_CHANGED).with(orderbook.getContract()).with(orderbook.getClosingPrice()));
        }
        if (orderbook.getOpeningPrice() != null && orderbook.getOpeningPriceDate() != null) {
            consumer.accept(StatusMessageBuilder.publicMessage(StatusMessageType.MSG_CONTRACT_OPENING_REFERENCE_PRICE_CHANGED).with(orderbook.getContract()).with(orderbook.getOpeningPrice()));
        }
    }

    private List<DeliveryArea> getTradingPhaseDeliveryAreasDelta(Contract oldContract, Contract newContract) {
        if (oldContract == null) {
            return Collections.emptyList();
        }
        List<DeliveryArea> deliveryAreas = oldContract.getCompoundStatus().getDeliveryAreas();
        return deliveryAreas.stream().filter(d -> newContract.getCompoundStatus().getActivePeriod((DeliveryArea)d) != null).filter(d -> !newContract.getCompoundStatus().getActivePeriod((DeliveryArea)d).equals(oldContract.getCompoundStatus().getActivePeriod((DeliveryArea)d))).toList();
    }

    private List<DeliveryArea> getDeliveryAreasDelta(Contract oldContract, Contract newContract, ContractStatus forContractStatus) {
        if (oldContract == null) {
            return Collections.emptyList();
        }
        List<DeliveryArea> deliveryAreas = oldContract.getCompoundStatus().getDeliveryAreas();
        Stream<DeliveryArea> activeDeliveryAreas = deliveryAreas.stream().filter(d -> oldContract.getCompoundStatus().getDeliveryAreaStatusOrInactive((DeliveryArea)d) != forContractStatus);
        return activeDeliveryAreas.filter(d -> newContract.getCompoundStatus().getDeliveryAreaStatusOrInactive((DeliveryArea)d) == forContractStatus).toList();
    }

    private List<DeliveryArea> getDeliveryAreasDelta(Contract oldContract, Contract newContract, ContractPhase contractPhase) {
        if (oldContract == null) {
            return Collections.emptyList();
        }
        List<DeliveryArea> deliveryAreas = oldContract.getCompoundStatus().getDeliveryAreas();
        return deliveryAreas.stream().filter(d -> oldContract.getCompoundStatus().getDeliveryAreaPhase((DeliveryArea)d) != contractPhase).filter(d -> newContract.getCompoundStatus().getDeliveryAreaPhase((DeliveryArea)d) == contractPhase).toList();
    }

    private void createLoginMessage(User user, Consumer<StatusMessageBuilder> consumer) {
        consumer.accept(StatusMessageBuilder.publicMessage(StatusMessageType.MSG_LOGIN).with(user));
    }

    private Message buildMessage(StatusMessageBuilder builder) {
        return Message.createServerMessage(this.activeExchange.getActiveExchange().get(), this.seqNumber.incrementAndGet(), this.timeService.getServerTime(), builder.build(), builder.getMessageType().getMessageSeverity(), builder.getMessageType().getMessageType(), false, builder.getSpecialMessage());
    }

    @Subscribe
    public void handleLoginMessage(LoginEvent loginEvent) {
        this.userTranslator.handleBroadcastEntity(this.userService.getOwnUser());
    }

    private boolean isCurrentUserAdmin() {
        return this.userService.getCurrentUser().getRoles().isAdmin();
    }

    private boolean isLoggedInUserAdmin() {
        return this.userService.getOwnUser().getRoles().isAdmin();
    }

    private boolean isMyTrade(HalfTrade halfTrade) {
        return this.userService.getCurrentUser().containsBalancingGroupId(halfTrade.getOrder().getBalancingGroupId());
    }

    private boolean isMyOrder(Order order) {
        return this.userService.getCurrentUser().containsBalancingGroupId(order.getBalancingGroupId());
    }

    private boolean isOrderPrearrangedForMe(Order order) {
        return this.userService.getCurrentUser().containsBalancingGroupId(order.getPreArrangedBalancingGroupId());
    }

    @Override
    public void stopOrderConverted(String clientOrderId) {
        this.stopOrderConvertedClientOrderIds.add(clientOrderId);
    }

    private class StatusMessageTranslator<B extends BroadcastEntity>
    implements EntityListener<B> {
        private Class<B> broadcastEntityClass;
        private BiConsumer<B, Consumer<StatusMessageBuilder>> broadcastConsumer;
        private List<StatusMessageBuilder> statusMessageBuilders = new ArrayList<StatusMessageBuilder>();

        public StatusMessageTranslator(Class<B> broadcastEntityClass, BiConsumer<B, Consumer<StatusMessageBuilder>> broadcastConsumer) {
            this.broadcastEntityClass = broadcastEntityClass;
            this.broadcastConsumer = broadcastConsumer;
        }

        @Override
        public Class<B> getEntityClass() {
            return this.broadcastEntityClass;
        }

        @Override
        public void handleBroadcastEntity(B broadcastEntity) {
            this.broadcastConsumer.accept(broadcastEntity, this.statusMessageBuilders::add);
            this.sendMessages();
        }

        @Override
        public void handleBroadcastEntities(Collection<B> broadcastEntities) {
            broadcastEntities.forEach(e -> this.broadcastConsumer.accept(e, this.statusMessageBuilders::add));
            this.sendMessages();
        }

        private void sendMessages() {
            List<Message> messages = this.statusMessageBuilders.stream().map(StatusMessageServiceImpl.this::buildMessage).toList();
            if (messages.size() > 1) {
                StatusMessageServiceImpl.this.messageDataModel.handleBroadcastEntities(messages);
            } else if (messages.size() == 1) {
                StatusMessageServiceImpl.this.messageDataModel.handleBroadcastEntity(messages.get(0));
            }
            this.statusMessageBuilders.clear();
        }
    }
}

