/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.amqp;

import com.deutscheboerse.comxerv.comtrader.entities.session.Session;
import com.deutscheboerse.comxerv.comtrader.monitoring.Monitor;
import com.deutscheboerse.comxerv.comtrader.service.amqp.UiThreadObjectHandler;
import com.deutscheboerse.m7.trading.api.v6.PblcOrdrBooksDeltaRprt;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchingBroadcastHandler {
    private static final Logger LOG = LoggerFactory.getLogger(BatchingBroadcastHandler.class);
    private static final int QUEUE_CAPACITY = 5000;
    private static final int MAX_BATCH_SIZE = 5000;
    private static final int UI_UPDATE_PERIOD_MS = 500;
    private final UiThreadObjectHandler uiThreadObjectHandler;
    private final ScheduledExecutorService broadcastExecutor = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("Broadcast-Batcher").build());
    private final BlockingQueue<Broadcast> broadcastQueue;
    private final List<Broadcast> reusableBatchBuffer = new ArrayList<Broadcast>(128);
    private final Monitor monitor;

    public BatchingBroadcastHandler(UiThreadObjectHandler uiThreadObjectHandler, Monitor monitor) {
        this(uiThreadObjectHandler, 5000, 500L, monitor);
    }

    BatchingBroadcastHandler(UiThreadObjectHandler uiThreadObjectHandler, int queueCapacity, long uiUpdatePeriodMs, Monitor monitor) {
        this.uiThreadObjectHandler = uiThreadObjectHandler;
        this.broadcastQueue = new ArrayBlockingQueue<Broadcast>(queueCapacity);
        this.broadcastExecutor.scheduleAtFixedRate(this::processBroadcasts, uiUpdatePeriodMs, uiUpdatePeriodMs, TimeUnit.MILLISECONDS);
        this.monitor = monitor;
    }

    public void stop() {
        this.broadcastExecutor.shutdownNow();
        this.broadcastQueue.clear();
    }

    public void handle(Session session, Object object, String correlationId) {
        try {
            this.broadcastQueue.put(new Broadcast(session, object, correlationId));
        }
        catch (InterruptedException e) {
            LOG.error("Interrupted while waiting on full broadcast queue.");
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Broadcast not handled, queue is full and current thread interrupted.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processBroadcasts() {
        List<Broadcast> batch = this.reusableBatchBuffer;
        try {
            this.drainQueueTo(batch);
            int batchCount = 0;
            Broadcast batchedOrderbook = null;
            for (Broadcast b : batch) {
                if (b.object instanceof PblcOrdrBooksDeltaRprt) {
                    ++batchCount;
                    batchedOrderbook = this.batchOrderbooks(batchedOrderbook, b);
                    continue;
                }
                this.uiThreadObjectHandler.handleObject(b.session, b.object, b.correlationId);
            }
            if (batchedOrderbook != null) {
                this.uiThreadObjectHandler.handleObject(batchedOrderbook.session, batchedOrderbook.object, batchedOrderbook.correlationId);
                LOG.debug("UI Thread invoked {}x  ", (Object)(batch.size() - batchCount + 1));
                this.monitor.uiThreadInvoked(batch.size() - batchCount + 1);
            }
        }
        catch (InterruptedException e) {
            LOG.info("Interrupted while waiting for next broadcast - exiting. Broadcasts not handled: {}", (Object)this.broadcastQueue);
            Thread.currentThread().interrupt();
        }
        finally {
            batch.clear();
        }
    }

    private Broadcast batchOrderbooks(Broadcast batchedOrderbook, Broadcast broadcast) {
        PblcOrdrBooksDeltaRprt.OrdrbookList ordrbookList = ((PblcOrdrBooksDeltaRprt)broadcast.object).getOrdrbookList();
        if (ordrbookList == null) {
            return batchedOrderbook;
        }
        if (batchedOrderbook == null) {
            batchedOrderbook = broadcast;
        } else {
            ((PblcOrdrBooksDeltaRprt)batchedOrderbook.object).getOrdrbookList().getOrdrBook().addAll(ordrbookList.getOrdrBook());
        }
        return batchedOrderbook;
    }

    private void drainQueueTo(List<Broadcast> batch) throws InterruptedException {
        batch.add(this.broadcastQueue.take());
        this.broadcastQueue.drainTo(batch, 4999);
        LOG.debug("New batch: {} broadcasts.", (Object)batch.size());
        this.monitor.batchSize(batch.size());
    }

    private static class Broadcast {
        private final Session session;
        private final Object object;
        private final String correlationId;

        public Broadcast(Session session, Object object, String correlationId) {
            this.session = session;
            this.object = object;
            this.correlationId = correlationId;
        }
    }
}

