/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.amqp;

import com.deutscheboerse.comxerv.comtrader.entities.session.ProxyType;
import com.deutscheboerse.comxerv.comtrader.service.ProxySettings;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.rabbitmq.client.Address;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.SocketConfigurator;
import com.rabbitmq.client.impl.FrameHandler;
import com.rabbitmq.client.impl.SocketFrameHandlerFactory;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.Socket;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.ProxyClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComTraderFrameHandlerFactory
extends SocketFrameHandlerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ComTraderFrameHandlerFactory.class);
    private final SocketFactory factory;
    private final ProxySettings proxySettings;

    public ComTraderFrameHandlerFactory(int connectionTimeout, SocketFactory factory, SocketConfigurator configurator, boolean ssl, ProxySettings proxySettings) {
        super(connectionTimeout, factory, configurator, ssl);
        this.factory = factory;
        this.proxySettings = proxySettings;
    }

    @Override
    public FrameHandler create(Address addr, String connectionName) throws IOException {
        String rabbitHostName = addr.getHost();
        int rabbitPortNumber = ConnectionFactory.portOrDefault(addr.getPort(), this.ssl);
        boolean connected = false;
        Socket socket = null;
        try {
            if (this.proxySettings.isProxyDefined()) {
                LOG.info("Set up {} PROXY:{}:{}", this.proxySettings.getProxyType(), this.proxySettings.getProxyHostname(), this.proxySettings.getProxyPortNumber());
                if (ProxyType.HTTP.equals(this.proxySettings.getProxyType())) {
                    ProxyClient proxyClient = new ProxyClient(RequestConfig.custom().setConnectTimeout(this.connectionTimeout).build());
                    HttpHost target = new HttpHost(rabbitHostName, rabbitPortNumber);
                    HttpHost proxy = new HttpHost(this.proxySettings.getProxyHostname(), this.proxySettings.getProxyPortNumber());
                    UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.proxySettings.getProxyUsername(), this.proxySettings.getProxyPassword());
                    socket = proxyClient.tunnel(proxy, target, credentials);
                    connected = true;
                } else {
                    InetSocketAddress socketAddress = new InetSocketAddress(this.proxySettings.getProxyHostname(), this.proxySettings.getProxyPortNumber());
                    Proxy proxy = new Proxy(Proxy.Type.SOCKS, socketAddress);
                    socket = new Socket(proxy);
                    if (this.proxySettings.isProxySecured()) {
                        LOG.info("PROXY is secured");
                        Authenticator.setDefault(new Authenticator(){

                            @Override
                            protected PasswordAuthentication getPasswordAuthentication() {
                                return new PasswordAuthentication(ComTraderFrameHandlerFactory.this.proxySettings.getProxyUsername(), ComTraderFrameHandlerFactory.this.proxySettings.getProxyPassword().toCharArray());
                            }

                            @Override
                            protected Authenticator.RequestorType getRequestorType() {
                                return Authenticator.RequestorType.PROXY;
                            }
                        });
                    }
                }
            } else {
                socket = this.factory.createSocket();
            }
            if (!connected) {
                this.configurator.configure(socket);
                socket.connect(new InetSocketAddress(rabbitHostName, rabbitPortNumber), this.connectionTimeout);
            }
            if (this.proxySettings.isProxyDefined() && this.ssl) {
                LOG.info("Set up layered SSL socket.");
                socket = ((SSLSocketFactory)this.factory).createSocket(socket, rabbitHostName, rabbitPortNumber, true);
            }
            return this.create(socket);
        }
        catch (IOException ioe) {
            Util.closeQuietly(socket);
            throw ioe;
        }
        catch (HttpException he) {
            Util.closeQuietly(socket);
            throw new IOException(he);
        }
    }
}

