/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.amqp;

import com.rabbitmq.client.AMQP;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageSequenceCheck {
    private static final Logger LOG = LoggerFactory.getLogger(MessageSequenceCheck.class);
    private final Map<String, Long> seqNoPerTopic = new ConcurrentHashMap<String, Long>();
    private final String groupHeaderName;
    private final String sequenceHeaderName;
    private final Set<String> ignoreTopics;

    public MessageSequenceCheck(String groupHeaderName, String sequenceHeaderName, Set<String> ignoreTopics) {
        this.groupHeaderName = groupHeaderName;
        this.sequenceHeaderName = sequenceHeaderName;
        this.ignoreTopics = ignoreTopics;
    }

    public Result checkSequenceNumber(AMQP.BasicProperties properties) {
        String topic = properties.getHeaders().get(this.groupHeaderName).toString();
        Long seqNo = (Long)properties.getHeaders().get(this.sequenceHeaderName);
        Long prevSeqNo = this.seqNoPerTopic.get(topic);
        if (prevSeqNo != null && prevSeqNo + 1L != seqNo && !this.ignoreTopics.contains(topic)) {
            LOG.error("Gap detected: {} {}->{}.", topic, prevSeqNo, seqNo);
            return new Result(true, topic, seqNo, prevSeqNo);
        }
        this.seqNoPerTopic.put(topic, seqNo);
        LOG.trace("Message sequence {} stored {}", (Object)topic, (Object)seqNo);
        return new Result(false, topic, seqNo, prevSeqNo);
    }

    public String getGroupHeaderName() {
        return this.groupHeaderName;
    }

    public String getSequenceHeaderName() {
        return this.sequenceHeaderName;
    }

    public void reset() {
        this.seqNoPerTopic.clear();
    }

    public static class Result {
        public static final Result OK = new Result(false, null, 0L, null);
        private final boolean gapDetected;
        private final String topic;
        private final long seqNo;
        private final Long prevSeqNo;

        Result(boolean gapDetected, String topic, long seqNo, Long prevSeqNo) {
            this.gapDetected = gapDetected;
            this.topic = topic;
            this.seqNo = seqNo;
            this.prevSeqNo = prevSeqNo;
        }

        public boolean isGapDetected() {
            return this.gapDetected;
        }

        public String getTopic() {
            return this.topic;
        }

        public long getSeqNo() {
            return this.seqNo;
        }

        public Long getPrevSeqNo() {
            return this.prevSeqNo;
        }

        public String toString() {
            return this.gapDetected ? "GAP detected: " + this.topic + ": " + this.prevSeqNo + " -> " + this.seqNo : "OK";
        }
    }
}

