/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.orderentry.preference;

import com.deutscheboerse.comxerv.comtrader.core.ActiveExchange;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModel;
import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.type.ValidityRestriction;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.preference.OrderPreferencesEntry;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.preference.OrderPreferencesService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.preference.SerializableOrderPreferencesEntry;
import com.deutscheboerse.comxerv.comtrader.service.settings.SettingsService;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javafx.beans.value.ObservableValue;

@Singleton
public class OrderPreferencesServiceImpl
implements OrderPreferencesService {
    private final SettingsService settingsService;
    private final DataModel<String, DeliveryArea> deliveryAreaDataModel;
    private final ObservableValue<Exchange> activeExchange;
    private static final SettingsService.Settings<List<SerializableOrderPreferencesEntry>> SERIAL_ORDER_PREFERENCES_LIST = new SettingsService.Settings("serializableOrderPreferencesList", new ArrayList());

    @Inject
    public OrderPreferencesServiceImpl(ApplicationContext applicationContext, SettingsService settingsService) {
        this.settingsService = settingsService;
        this.deliveryAreaDataModel = applicationContext.getDataModel(DeliveryArea.class);
        this.activeExchange = applicationContext.getService(ActiveExchange.class).getActiveExchange();
    }

    @Override
    public void storeOrderPreferences(List<OrderPreferencesEntry> orderPreferencesEntries) {
        this.settingsService.storeSettings(SERIAL_ORDER_PREFERENCES_LIST, orderPreferencesEntries.stream().map(SerializableOrderPreferencesEntry::new).toList());
    }

    @Override
    public List<OrderPreferencesEntry> getOrderPreferences() {
        return this.settingsService.loadSettings(SERIAL_ORDER_PREFERENCES_LIST).stream().map(o -> new OrderPreferencesEntry(this.deliveryAreaDataModel, (SerializableOrderPreferencesEntry)o)).toList();
    }

    @Override
    public Optional<OrderPreferencesEntry> getOrderPreference() {
        Predicate<OrderPreferencesEntry> contractPlaceHolder = entry -> "*".equals(entry.getContract());
        Predicate<OrderPreferencesEntry> productPlaceHolder = entry -> "*".equals(entry.getProduct());
        Optional<OrderPreferencesEntry> productPlaceHolderContractPlaceholder = this.getOrderPreferences().stream().filter(contractPlaceHolder.and(productPlaceHolder)).findFirst();
        if (productPlaceHolderContractPlaceholder.isPresent()) {
            return productPlaceHolderContractPlaceholder;
        }
        return Optional.empty();
    }

    @Override
    public Optional<OrderPreferencesEntry> getOrderPreferencesForContract(Contract contract) {
        Predicate<OrderPreferencesEntry> contractPlaceHolder = entry -> "*".equals(entry.getContract());
        Predicate<OrderPreferencesEntry> productPlaceHolder = entry -> "*".equals(entry.getProduct());
        Predicate<OrderPreferencesEntry> contractMatches = entry -> entry.getContract().equals(contract.getName());
        Predicate<OrderPreferencesEntry> productMatches = entry -> entry.getProduct().equals(contract.getProduct().getDisplayName());
        Optional<OrderPreferencesEntry> productPlaceHolderContractPlaceholder = this.getOrderPreferences().stream().filter(contractPlaceHolder.and(productPlaceHolder)).findFirst();
        Optional<OrderPreferencesEntry> productMatchesContractPlaceholder = this.getOrderPreferences().stream().filter(productMatches.and(contractPlaceHolder)).findFirst();
        Optional<OrderPreferencesEntry> productMatchesContractMatches = this.getOrderPreferences().stream().filter(productMatches.and(contractMatches)).findFirst();
        if (productMatchesContractMatches.isPresent()) {
            return productMatchesContractMatches;
        }
        if (productMatchesContractPlaceholder.isPresent()) {
            return productMatchesContractPlaceholder;
        }
        if (productPlaceHolderContractPlaceholder.isPresent()) {
            return productPlaceHolderContractPlaceholder;
        }
        return Optional.empty();
    }

    @Override
    public String getDefaultAccount() {
        String defaultAccount = this.getOrderPreference().map(OrderPreferencesEntry::getAccountType).orElse(null);
        return this.getValidAccountTypeDefault(defaultAccount);
    }

    @Override
    public ValidityRestriction getDefaultValidityRestriction() {
        return this.getOrderPreference().map(OrderPreferencesEntry::getValidityRestriction).orElse(DEFAULT_VALIDITY_RESTRICTION);
    }

    @Override
    public String getDefaultDeliveryAreaId() {
        return this.getOrderPreference().map(OrderPreferencesEntry::getDeliveryArea).map(BroadcastEntity::getId).orElse(null);
    }

    @Override
    public DeliveryArea getDefaultDeliveryArea() {
        return this.deliveryAreaDataModel.findById(this.getDefaultDeliveryAreaId());
    }

    private String getValidAccountTypeDefault(String value) {
        String accountTypeDefault = "";
        Exchange exchange = this.activeExchange.getValue();
        if (exchange != null && exchange.getSystemInfo() != null) {
            if (value != null && exchange.getSystemInfo().getAllowedClearingAccountTypes().contains(value)) {
                return value;
            }
            if (exchange.getSystemInfo().getAllowedClearingAccountTypes().contains(DEFAULT_ACCOUNT_TYPE_1)) {
                return DEFAULT_ACCOUNT_TYPE_1;
            }
            if (exchange.getSystemInfo().getAllowedClearingAccountTypes().contains(DEFAULT_ACCOUNT_TYPE_2)) {
                return DEFAULT_ACCOUNT_TYPE_2;
            }
            return exchange.getSystemInfo().getAllowedClearingAccountTypes().stream().findFirst().orElse("");
        }
        return accountTypeDefault;
    }
}

