/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.orderentry.protection;

import com.deutscheboerse.comxerv.comtrader.core.util.DisplayName;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.Set;

public enum OrderEntryRuleDirection implements DisplayName,
Serializable
{
    BOTH("commons_both", EnumSet.allOf(Direction.class)),
    BUY("commons_buy", EnumSet.of(Direction.BUY)),
    SELL("commons_sell", EnumSet.of(Direction.SELL));

    private static final long serialVersionUID = 1L;
    private String labelKey;
    private Set<Direction> matchingDirections;

    private OrderEntryRuleDirection(String labelKey, Set<Direction> matchingDirections) {
        this.labelKey = labelKey;
        this.matchingDirections = matchingDirections;
    }

    public boolean matchesDirection(Direction direction) {
        return this.matchingDirections.contains(direction);
    }

    @Override
    public String getDisplayName() {
        return Util.getLabel(this.labelKey);
    }
}

