/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.profile;

import com.deutscheboerse.comxerv.comtrader.service.orderentry.protection.SerializableOrderEntryRule;
import com.deutscheboerse.comxerv.comtrader.service.profile.ProfileContentWithFormatVersion;
import com.deutscheboerse.comxerv.comtrader.service.profile.ProfileMigration;
import com.deutscheboerse.comxerv.comtrader.service.profile.ProfileMigrationService;
import com.deutscheboerse.comxerv.comtrader.service.profile.ProfileSerializer;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V1000006OrderEntryProtectionRuleList
implements ProfileMigration {
    private static final Logger LOG = LoggerFactory.getLogger(V1000006OrderEntryProtectionRuleList.class);
    private static final long NEW_VERSION = 1000006L;
    private final ProfileSerializer profileSerializer;

    @Inject
    public V1000006OrderEntryProtectionRuleList(ProfileMigrationService profileMigrationService, ProfileSerializer profileSerializer) {
        profileMigrationService.registerProfileMigration(this, 1000006L);
        this.profileSerializer = profileSerializer;
    }

    @Override
    public ProfileContentWithFormatVersion apply(ProfileContentWithFormatVersion profile) {
        LOG.info("Running profile migration {}", (Object)1000006L);
        profile.setFormatVersion(1000006L);
        for (Map.Entry<String, String> entry : profile.getSettings().entrySet()) {
            if (!"orderEntryProtectionRuleList".equals(entry.getKey()) || entry.getValue() == null || !entry.getValue().contains("ObservableListWrapper")) continue;
            entry.setValue(this.serializeValue(this.deserializeValue(entry.getValue())));
        }
        return profile;
    }

    private String serializeValue(List<SerializableOrderEntryRule> value) {
        return this.profileSerializer.writeValue(value);
    }

    private List<SerializableOrderEntryRule> deserializeValue(String serializedValue) {
        return ((List)this.profileSerializer.readValue(serializedValue)).stream().map(SerializableOrderEntryRule::new).toList();
    }
}

