/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.remote;

import com.deutscheboerse.comxerv.comtrader.app.login.MasterLoginModel;
import com.deutscheboerse.comxerv.comtrader.entities.session.ProxyType;
import com.deutscheboerse.comxerv.comtrader.service.LoginException;
import com.deutscheboerse.comxerv.comtrader.service.ProxySettings;
import com.deutscheboerse.comxerv.comtrader.service.SecureConnectionHelper;
import com.deutscheboerse.m7.comtrader.remote.common.RemoteService;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.xml.ws.WebServiceException;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.configuration.security.ProxyAuthorizationPolicy;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.transports.http.configuration.ProxyServerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class WebServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(WebServiceFactory.class);
    private static final int HTTP_CONNECTION_TIMEOUT = 15000;
    private static final int HTTP_RECEIVE_TIMEOUT = 30000;
    private final MasterLoginModel masterLoginModel;
    private final ProxySettings proxySettings;

    @Inject
    public WebServiceFactory(MasterLoginModel masterLoginModel, ProxySettings proxySettings) {
        this.masterLoginModel = masterLoginModel;
        this.proxySettings = proxySettings;
    }

    public <T extends RemoteService> T getWebService(Class<T> serviceClass, String baseServicesUrl, String serviceName, boolean disableHostnameCheck) {
        RemoteService jaxWsProxy = (RemoteService)WebServiceFactory.createWebServiceClient(serviceClass, baseServicesUrl, serviceName);
        Client client = ClientProxy.getClient(jaxWsProxy);
        HTTPConduit httpConduit = (HTTPConduit)client.getConduit();
        HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
        httpClientPolicy.setConnectionTimeout(15000L);
        httpClientPolicy.setReceiveTimeout(30000L);
        httpConduit.setClient(httpClientPolicy);
        if (baseServicesUrl.startsWith("https")) {
            this.configureSSL(httpConduit, disableHostnameCheck);
        }
        this.configureProxy(httpConduit);
        AuthorizationPolicy authorization = new AuthorizationPolicy();
        authorization.setUserName(this.masterLoginModel.getMasterUsername());
        authorization.setPassword(this.masterLoginModel.getMasterPassword());
        authorization.setAuthorizationType("Basic");
        httpConduit.setAuthorization(authorization);
        return (T)jaxWsProxy;
    }

    private static <T> T createWebServiceClient(Class<T> serviceClass, String baseServicesUrl, String serviceName) {
        JaxWsProxyFactoryBean jaxWsProxyFactoryBean = new JaxWsProxyFactoryBean();
        jaxWsProxyFactoryBean.getInInterceptors().add(new LoggingInterceptor());
        jaxWsProxyFactoryBean.getOutInterceptors().add(new LoggingInterceptor());
        jaxWsProxyFactoryBean.setServiceClass(serviceClass);
        jaxWsProxyFactoryBean.setAddress(baseServicesUrl + serviceName);
        LOG.info("Creating web service client for {}", (Object)jaxWsProxyFactoryBean.getAddress());
        return (T)jaxWsProxyFactoryBean.create();
    }

    private void configureSSL(HTTPConduit httpConduit, boolean disableHostnameCheck) {
        TLSClientParameters tls = new TLSClientParameters();
        try {
            tls.setTrustManagers(SecureConnectionHelper.getTrustManagers(this.masterLoginModel.getConnectionParameters().getExchange().getCustomTrustStore(), this.masterLoginModel.getConnectionParameters().getExchange().getCustomTrustStorePassword()));
            tls.setDisableCNCheck(disableHostnameCheck);
            LOG.debug("Hostname checking disabled = {}", (Object)disableHostnameCheck);
        }
        catch (LoginException | IOException | GeneralSecurityException e) {
            throw new WebServiceException("Error when getting trust managers", e);
        }
        httpConduit.setTlsClientParameters(tls);
    }

    private void configureProxy(HTTPConduit http) {
        if (this.proxySettings.getProxyType().isProxy()) {
            http.getClient().setProxyServer(this.proxySettings.getProxyHostname());
            http.getClient().setProxyServerPort(this.proxySettings.getProxyPortNumber());
            http.getClient().setProxyServerType(WebServiceFactory.toProxyServerType(this.proxySettings.getProxyType()));
            LOG.info("Web service {} proxy set to {}:{}", new Object[]{http.getClient().getProxyServerType(), http.getClient().getProxyServer(), http.getClient().getProxyServerPort()});
            if (this.proxySettings.isProxySecured()) {
                ProxyAuthorizationPolicy proxyAuth = new ProxyAuthorizationPolicy();
                proxyAuth.setUserName(this.proxySettings.getProxyUsername());
                proxyAuth.setPassword(this.proxySettings.getProxyPassword());
                http.setProxyAuthorization(proxyAuth);
            }
        }
    }

    private static ProxyServerType toProxyServerType(ProxyType proxyType) {
        switch (proxyType) {
            case HTTP: {
                return ProxyServerType.HTTP;
            }
            case SOCKS: {
                return ProxyServerType.SOCKS;
            }
        }
        throw new UnsupportedOperationException();
    }

    private static class LoggingInterceptor
    extends AbstractPhaseInterceptor<Message> {
        public LoggingInterceptor() {
            super("pre-invoke");
        }

        @Override
        public void handleMessage(Message message) {
            LOG.info("Remote operation {} returned {}", message.get("javax.xml.ws.wsdl.operation"), message.get(Message.RESPONSE_CODE));
        }

        @Override
        public void handleFault(Message message) {
            LOG.error("Interceptor execution aborted: {}", (Object)message);
        }
    }
}

