/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.util.concurrent;

import com.deutscheboerse.comxerv.comtrader.util.concurrent.ConditionRunnable;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForkJoin
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ForkJoin.class);
    private final Executor executor;
    private final ConditionRunnable[] tasks;

    public ForkJoin(Executor executor, ConditionRunnable ... tasks) {
        this.executor = executor;
        this.tasks = tasks;
    }

    @Override
    public void run() {
        if (this.tasks == null || this.tasks.length == 0) {
            return;
        }
        Long count = Arrays.stream(this.tasks).filter(ConditionRunnable::runCondition).count();
        final CountDownLatch latch = new CountDownLatch(count.intValue());
        for (ConditionRunnable task : this.tasks) {
            if (!task.runCondition()) continue;
            final ConditionRunnable finalTask = task;
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        finalTask.run();
                    }
                    finally {
                        latch.countDown();
                    }
                }

                public String toString() {
                    return finalTask.toString();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            LOG.info("Thread interrupted");
            Thread.currentThread().interrupt();
            return;
        }
    }
}

