/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.util.concurrent;

import com.deutscheboerse.comxerv.comtrader.util.concurrent.SlicedRunnable;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SlicedTask<T, S>
extends SlicedRunnable<T> {
    private static final Logger LOG = LoggerFactory.getLogger(SlicedTask.class);
    private final Executor executor;

    public SlicedTask(String taskName, Executor executor, Collection<T> sliceInputs) {
        super(taskName, sliceInputs);
        this.executor = executor;
    }

    @Override
    public void run() {
        final CountDownLatch latch = new CountDownLatch(this.sliceInputs.size());
        final Object sync = new Object();
        final CopyOnWriteArrayList<RuntimeException> exceptions = new CopyOnWriteArrayList<RuntimeException>();
        for (final Object sliceInput : this.sliceInputs) {
            this.executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Object asyncOutput = SlicedTask.this.runSlowAsyncPart(sliceInput);
                        Object object = sync;
                        synchronized (object) {
                            SlicedTask.this.runFastSyncPart(asyncOutput);
                        }
                    }
                    catch (RuntimeException e) {
                        exceptions.add(e);
                    }
                    finally {
                        latch.countDown();
                    }
                }

                public String toString() {
                    return SlicedTask.this.taskName + " - " + sliceInput.toString();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            LOG.info("Thread interrupted");
            Thread.currentThread().interrupt();
            return;
        }
        this.handleExceptions(exceptions);
    }

    protected abstract S runSlowAsyncPart(T var1);

    protected abstract void runFastSyncPart(S var1);
}

