/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.util.concurrent;

import com.deutscheboerse.comxerv.comtrader.service.event.ApplicationShutdownEvent;
import com.deutscheboerse.ui.jfx.util.LoggingCallable;
import com.deutscheboerse.ui.jfx.util.LoggingRunnable;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolAutoShutdownScheduledExecutorService
implements ScheduledExecutorService {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadPoolAutoShutdownScheduledExecutorService.class);
    protected static final int AWAIT_TERMINATION_TIMEOUT_IN_SECONDS = 5;
    private final ScheduledExecutorService delegate;

    public ThreadPoolAutoShutdownScheduledExecutorService(EventBus eventBus, int poolSize, String prefix) {
        this(eventBus, Executors.newScheduledThreadPool(poolSize, new ThreadFactoryBuilder().setNameFormat(prefix + "-%d").build()));
    }

    protected ThreadPoolAutoShutdownScheduledExecutorService(EventBus eventBus, ScheduledExecutorService delegate) {
        this.delegate = delegate;
        eventBus.register(this);
    }

    @Subscribe
    public void handleApplicationShutdownEvent(ApplicationShutdownEvent event) {
        try {
            this.delegate.shutdown();
            if (!this.delegate.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.forceShutdown();
            }
        }
        catch (InterruptedException e) {
            LOG.warn("InterruptedException", e);
            Thread.currentThread().interrupt();
            this.forceShutdown();
        }
    }

    private Runnable wrapWithLogging(Runnable runnable) {
        return new LoggingRunnable(runnable);
    }

    private <V> Callable<V> wrapWithLogging(Callable<V> callable) {
        return new LoggingCallable<V>(callable);
    }

    private <T> Collection<? extends Callable<T>> wrapWithLogging(Collection<? extends Callable<T>> tasks) {
        return tasks.stream().map(this::wrapWithLogging).toList();
    }

    private void forceShutdown() {
        List<Runnable> remainingTasks = this.delegate.shutdownNow();
        String remainingTasksNames = remainingTasks.stream().filter(Objects::nonNull).map((Function<Runnable, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Ljava/lang/Runnable;)Ljava/lang/String;)()).collect(Collectors.joining("\n"));
        LOG.warn("Some tasks didn't finish:\n {}", (Object)remainingTasksNames);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.delegate.schedule(this.wrapWithLogging(command), delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.delegate.schedule(this.wrapWithLogging(callable), delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.delegate.scheduleAtFixedRate(this.wrapWithLogging(command), initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.delegate.scheduleWithFixedDelay(this.wrapWithLogging(command), initialDelay, delay, unit);
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.delegate.submit(this.wrapWithLogging(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.delegate.submit(this.wrapWithLogging(task), result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.delegate.submit(this.wrapWithLogging(task));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.delegate.invokeAll(this.wrapWithLogging(tasks));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.invokeAll(this.wrapWithLogging(tasks), timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.delegate.invokeAny(this.wrapWithLogging(tasks));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.invokeAny(this.wrapWithLogging(tasks), timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.delegate.execute(this.wrapWithLogging(command));
    }
}

