/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.ui.jfx.util.binding;

import com.google.common.collect.Lists;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.beans.Observable;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public abstract class DependentBinding<T>
extends ObjectBinding<T> {
    private final Observable[] dependencies;

    protected DependentBinding(Observable ... dependencies) {
        this.dependencies = dependencies;
        this.bind(dependencies);
    }

    public static <T> DependentBinding<T> get(final Supplier<T> supplier, Observable ... dependencies) {
        return new DependentBinding<T>(dependencies){

            @Override
            protected T computeValue() {
                return supplier.get();
            }
        };
    }

    public static <S, T> DependentBinding<T> get(Function<S, T> supplier, ObservableValue<S> provider) {
        return DependentBinding.get(supplier, provider, null);
    }

    public static <S, T> DependentBinding<T> get(final Function<S, T> supplier, final ObservableValue<S> provider, final T defaultValue) {
        return new DependentBinding<T>(new Observable[]{provider}){

            @Override
            protected T computeValue() {
                Object value = provider.getValue();
                return value != null ? supplier.apply(value) : defaultValue;
            }
        };
    }

    public static <S, T> DependentBinding<T> get(final Function<S, T> supplier, final ObservableValue<S> provider, final T defaultValue, Observable ... otherDependencies) {
        return new DependentBinding<T>(Lists.asList(provider, otherDependencies).toArray(new Observable[otherDependencies.length + 1])){

            @Override
            protected T computeValue() {
                Object value = provider.getValue();
                return value != null ? supplier.apply(value) : defaultValue;
            }
        };
    }

    @Override
    public void dispose() {
        this.unbind(this.dependencies);
    }

    @Override
    public ObservableList<?> getDependencies() {
        return FXCollections.unmodifiableObservableList(FXCollections.observableArrayList(this.dependencies));
    }
}

