/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.mutable.primitive;

import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.iterator.MutableDoubleIterator;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.ParallelUnsortedSetIterable;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.impl.set.mutable.AbstractMutableSet;

public class BoxedMutableDoubleSet
extends AbstractMutableSet<Double>
implements MutableSet<Double> {
    private final MutableDoubleSet delegate;

    public BoxedMutableDoubleSet(MutableDoubleSet delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public Double getFirst() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Double getLast() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void each(Procedure<? super Double> procedure) {
        this.delegate.each(procedure::value);
    }

    @Override
    public boolean add(Double item) {
        return this.delegate.add(item);
    }

    @Override
    public boolean contains(Object object) {
        return object instanceof Double && this.delegate.contains((Double)object);
    }

    @Override
    public boolean remove(Object object) {
        return object instanceof Double && this.delegate.remove((Double)object);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public ParallelUnsortedSetIterable<Double> asParallel(ExecutorService executorService, int batchSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Set)) {
            return false;
        }
        Set other = (Set)object;
        return this.size() == other.size() && this.containsAll(other);
    }

    @Override
    public Iterator<Double> iterator() {
        return new BoxedPrimitiveDoubleSetIterator(this.delegate.doubleIterator());
    }

    private static final class BoxedPrimitiveDoubleSetIterator
    implements Iterator<Double> {
        private final MutableDoubleIterator delegate;

        private BoxedPrimitiveDoubleSetIterator(MutableDoubleIterator iterator2) {
            this.delegate = iterator2;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public Double next() {
            return this.delegate.next();
        }
    }
}

