/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.tuple.primitive;

import org.eclipse.collections.api.tuple.primitive.FloatIntPair;

public class FloatIntPairImpl
implements FloatIntPair {
    private static final long serialVersionUID = 1L;
    private final float one;
    private final int two;

    FloatIntPairImpl(float newOne, int newTwo) {
        this.one = newOne;
        this.two = newTwo;
    }

    @Override
    public float getOne() {
        return this.one;
    }

    @Override
    public int getTwo() {
        return this.two;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FloatIntPair)) {
            return false;
        }
        FloatIntPair that = (FloatIntPair)o;
        return Float.compare(this.one, that.getOne()) == 0 && this.two == that.getTwo();
    }

    public int hashCode() {
        return 29 * Float.floatToIntBits(this.one) + this.two;
    }

    public String toString() {
        return this.one + ":" + this.two;
    }

    @Override
    public int compareTo(FloatIntPair that) {
        int i = Float.compare(this.one, that.getOne());
        if (i != 0) {
            return i;
        }
        return this.two < that.getTwo() ? -1 : (this.two > that.getTwo() ? 1 : 0);
    }
}

