/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import javafx.beans.NamedArg;
import javafx.scene.Node;
import org.fxmisc.richtext.StyledTextArea;
import org.fxmisc.richtext.model.Codec;
import org.fxmisc.richtext.model.EditableStyledDocument;
import org.fxmisc.richtext.model.ReadOnlyStyledDocument;
import org.fxmisc.richtext.model.SimpleEditableStyledDocument;
import org.fxmisc.richtext.model.TwoDimensional;

public class InlineCssTextArea
extends StyledTextArea<String, String> {
    public InlineCssTextArea() {
        this(new SimpleEditableStyledDocument<String, String>("", ""));
    }

    public InlineCssTextArea(@NamedArg(value="document") EditableStyledDocument<String, String, String> document) {
        super("", Node::setStyle, "", Node::setStyle, document, true);
        this.setStyleCodecs(Codec.STRING_CODEC, Codec.styledTextCodec(Codec.STRING_CODEC));
    }

    public InlineCssTextArea(@NamedArg(value="text") String text) {
        this();
        this.replace(0, 0, ReadOnlyStyledDocument.fromString(text, (String)this.getInitialParagraphStyle(), (String)this.getInitialTextStyle(), this.getSegOps()));
        this.getUndoManager().forgetHistory();
        this.getUndoManager().mark();
        this.selectRange(0, 0);
    }

    public void foldParagraphs(int startPar, int endPar) {
        this.foldParagraphs(startPar, endPar, this.getAddFoldStyle());
    }

    public void foldSelectedParagraphs() {
        this.foldSelectedParagraphs(this.getAddFoldStyle());
    }

    public void foldText(int start, int end) {
        this.fold(start, end, this.getAddFoldStyle());
    }

    public boolean isFolded(int paragraph) {
        return this.getFoldStyleCheck().test((String)this.getParagraph(paragraph).getParagraphStyle());
    }

    public void unfoldParagraphs(int startingFromPar) {
        this.unfoldParagraphs(startingFromPar, this.getFoldStyleCheck(), this.getRemoveFoldStyle());
    }

    public void unfoldText(int startingFromPos) {
        startingFromPos = this.offsetToPosition(startingFromPos, TwoDimensional.Bias.Backward).getMajor();
        this.unfoldParagraphs(startingFromPos, this.getFoldStyleCheck(), this.getRemoveFoldStyle());
    }

    protected Predicate<String> getFoldStyleCheck() {
        return pstyle -> pstyle != null && pstyle.contains("collapse");
    }

    protected UnaryOperator<String> getAddFoldStyle() {
        return pstyle -> "visibility: collapse;" + (pstyle != null ? pstyle : "");
    }

    protected UnaryOperator<String> getRemoveFoldStyle() {
        return pstyle -> pstyle.replaceFirst("visibility: collapse;", "");
    }
}

