/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.undo;

import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.fxmisc.undo.UndoManager;
import org.fxmisc.undo.impl.FixedSizeChangeQueue;
import org.fxmisc.undo.impl.MultiChangeUndoManagerImpl;
import org.fxmisc.undo.impl.UndoManagerImpl;
import org.fxmisc.undo.impl.UnlimitedChangeQueue;
import org.fxmisc.undo.impl.ZeroSizeChangeQueue;
import org.reactfx.EventStream;

public interface UndoManagerFactory {
    default public <C> UndoManager<C> createSingleChangeUM(EventStream<C> changeStream, Function<? super C, ? extends C> invert, Consumer<C> apply) {
        return this.createSingleChangeUM(changeStream, invert, apply, (c1, c2) -> Optional.empty());
    }

    default public <C> UndoManager<C> createSingleChangeUM(EventStream<C> changeStream, Function<? super C, ? extends C> invert, Consumer<C> apply, BiFunction<C, C, Optional<C>> merge) {
        return this.createSingleChangeUM(changeStream, invert, apply, merge, c -> false);
    }

    default public <C> UndoManager<C> createSingleChangeUM(EventStream<C> changeStream, Function<? super C, ? extends C> invert, Consumer<C> apply, BiFunction<C, C, Optional<C>> merge, Predicate<C> isIdentity) {
        return this.createSingleChangeUM(changeStream, invert, apply, merge, isIdentity, Duration.ZERO);
    }

    public <C> UndoManager<C> createSingleChangeUM(EventStream<C> var1, Function<? super C, ? extends C> var2, Consumer<C> var3, BiFunction<C, C, Optional<C>> var4, Predicate<C> var5, Duration var6);

    public static <C> UndoManager<C> unlimitedHistorySingleChangeUM(EventStream<C> changeStream, Function<? super C, ? extends C> invert, Consumer<C> apply) {
        return UndoManagerFactory.unlimitedHistorySingleChangeUM(changeStream, invert, apply, (c1, c2) -> Optional.empty());
    }

    public static <C> UndoManager<C> unlimitedHistorySingleChangeUM(EventStream<C> changeStream, Function<? super C, ? extends C> invert, Consumer<C> apply, BiFunction<C, C, Optional<C>> merge) {
        return UndoManagerFactory.unlimitedHistorySingleChangeUM(changeStream, invert, apply, merge, c -> false, Duration.ZERO);
    }

    public static <C> UndoManager<C> unlimitedHistorySingleChangeUM(EventStream<C> changeStream, Function<? super C, ? extends C> invert, Consumer<C> apply, BiFunction<C, C, Optional<C>> merge, Predicate<C> isIdentity) {
        return UndoManagerFactory.unlimitedHistorySingleChangeUM(changeStream, invert, apply, merge, isIdentity, Duration.ZERO);
    }

    public static <C> UndoManager<C> unlimitedHistorySingleChangeUM(EventStream<C> changeStream, Function<? super C, ? extends C> invert, Consumer<C> apply, BiFunction<C, C, Optional<C>> merge, Predicate<C> isIdentity, Duration preventMergeDelay) {
        UnlimitedChangeQueue queue2 = new UnlimitedChangeQueue();
        return new UndoManagerImpl<C>(queue2, invert, apply, merge, isIdentity, changeStream, preventMergeDelay);
    }

    public static <C> UndoManager<C> fixedSizeHistorySingleChangeUM(EventStream<C> changeStream, Function<? super C, ? extends C> invert, Consumer<C> apply, int capacity) {
        return UndoManagerFactory.fixedSizeHistorySingleChangeUM(changeStream, invert, apply, (c1, c2) -> Optional.empty(), capacity);
    }

    public static <C> UndoManager<C> fixedSizeHistorySingleChangeUM(EventStream<C> changeStream, Function<? super C, ? extends C> invert, Consumer<C> apply, BiFunction<C, C, Optional<C>> merge, int capacity) {
        return UndoManagerFactory.fixedSizeHistorySingleChangeUM(changeStream, invert, apply, merge, c -> false, Duration.ZERO, capacity);
    }

    public static <C> UndoManager<C> fixedSizeHistorySingleChangeUM(EventStream<C> changeStream, Function<? super C, ? extends C> invert, Consumer<C> apply, BiFunction<C, C, Optional<C>> merge, Predicate<C> isIdentity, Duration preventMergeDelay, int capacity) {
        FixedSizeChangeQueue queue2 = new FixedSizeChangeQueue(capacity);
        return new UndoManagerImpl<C>(queue2, invert, apply, merge, isIdentity, changeStream, preventMergeDelay);
    }

    public static <C> UndoManager<C> zeroHistorySingleChangeUM(EventStream<C> changeStream) {
        ZeroSizeChangeQueue queue2 = new ZeroSizeChangeQueue();
        return new UndoManagerImpl<Object>(queue2, c -> c, c -> {}, (c1, c2) -> Optional.empty(), c -> false, changeStream);
    }

    default public <C> UndoManager<List<C>> createMultiChangeUM(EventStream<List<C>> changeStream, Function<? super C, ? extends C> invert, Consumer<List<C>> apply) {
        return this.createMultiChangeUM(changeStream, invert, apply, (c1, c2) -> Optional.empty());
    }

    default public <C> UndoManager<List<C>> createMultiChangeUM(EventStream<List<C>> changeStream, Function<? super C, ? extends C> invert, Consumer<List<C>> apply, BiFunction<C, C, Optional<C>> merge) {
        return this.createMultiChangeUM(changeStream, invert, apply, merge, c -> false);
    }

    default public <C> UndoManager<List<C>> createMultiChangeUM(EventStream<List<C>> changeStream, Function<? super C, ? extends C> invert, Consumer<List<C>> apply, BiFunction<C, C, Optional<C>> merge, Predicate<C> isIdentity) {
        return this.createMultiChangeUM(changeStream, invert, apply, merge, isIdentity, Duration.ZERO);
    }

    public <C> UndoManager<List<C>> createMultiChangeUM(EventStream<List<C>> var1, Function<? super C, ? extends C> var2, Consumer<List<C>> var3, BiFunction<C, C, Optional<C>> var4, Predicate<C> var5, Duration var6);

    public static <C> UndoManager<List<C>> unlimitedHistoryMultiChangeUM(EventStream<List<C>> changeStream, Function<? super C, ? extends C> invert, Consumer<List<C>> apply) {
        return UndoManagerFactory.unlimitedHistoryMultiChangeUM(changeStream, invert, apply, (c1, c2) -> Optional.empty());
    }

    public static <C> UndoManager<List<C>> unlimitedHistoryMultiChangeUM(EventStream<List<C>> changeStream, Function<? super C, ? extends C> invert, Consumer<List<C>> apply, BiFunction<C, C, Optional<C>> merge) {
        return UndoManagerFactory.unlimitedHistoryMultiChangeUM(changeStream, invert, apply, merge, c -> false, Duration.ZERO);
    }

    public static <C> UndoManager<List<C>> unlimitedHistoryMultiChangeUM(EventStream<List<C>> changeStream, Function<? super C, ? extends C> invert, Consumer<List<C>> apply, BiFunction<C, C, Optional<C>> merge, Predicate<C> isIdentity) {
        return UndoManagerFactory.unlimitedHistoryMultiChangeUM(changeStream, invert, apply, merge, isIdentity, Duration.ZERO);
    }

    public static <C> UndoManager<List<C>> unlimitedHistoryMultiChangeUM(EventStream<List<C>> changeStream, Function<? super C, ? extends C> invert, Consumer<List<C>> apply, BiFunction<C, C, Optional<C>> merge, Predicate<C> isIdentity, Duration preventMergeDelay) {
        UnlimitedChangeQueue queue2 = new UnlimitedChangeQueue();
        return new MultiChangeUndoManagerImpl<C>(queue2, invert, apply, merge, isIdentity, changeStream, preventMergeDelay);
    }

    public static <C> UndoManager<List<C>> fixedSizeHistoryMultiChangeUM(EventStream<List<C>> changeStream, Function<? super C, ? extends C> invert, Consumer<List<C>> apply, int capacity) {
        return UndoManagerFactory.fixedSizeHistoryMultiChangeUM(changeStream, invert, apply, (c1, c2) -> Optional.empty(), capacity);
    }

    public static <C> UndoManager<List<C>> fixedSizeHistoryMultiChangeUM(EventStream<List<C>> changeStream, Function<? super C, ? extends C> invert, Consumer<List<C>> apply, BiFunction<C, C, Optional<C>> merge, int capacity) {
        return UndoManagerFactory.fixedSizeHistoryMultiChangeUM(changeStream, invert, apply, merge, c -> false, Duration.ZERO, capacity);
    }

    public static <C> UndoManager<List<C>> fixedSizeHistoryMultiChangeUM(EventStream<List<C>> changeStream, Function<? super C, ? extends C> invert, Consumer<List<C>> apply, BiFunction<C, C, Optional<C>> merge, Predicate<C> isIdentity, Duration preventMergeDelay, int capacity) {
        FixedSizeChangeQueue queue2 = new FixedSizeChangeQueue(capacity);
        return new MultiChangeUndoManagerImpl<C>(queue2, invert, apply, merge, isIdentity, changeStream, preventMergeDelay);
    }

    public static <C> UndoManager<List<C>> zeroHistoryMultiChangeUM(EventStream<List<C>> changeStream) {
        ZeroSizeChangeQueue queue2 = new ZeroSizeChangeQueue();
        Consumer doNothingForUndoAndRedo = c -> {};
        return new MultiChangeUndoManagerImpl<Object>(queue2, c -> c, doNothingForUndoAndRedo, (BiFunction<Object, Object, Optional<Object>>)((BiFunction<Object, Object, Optional>)(c1, c2) -> Optional.empty()), c -> false, (EventStream<List<Object>>)changeStream);
    }

    public static UndoManagerFactory unlimitedHistoryFactory() {
        return new UndoManagerFactory(){

            @Override
            public <C> UndoManager<C> createSingleChangeUM(EventStream<C> changeStream, Function<? super C, ? extends C> invert, Consumer<C> apply, BiFunction<C, C, Optional<C>> merge, Predicate<C> isIdentity, Duration preventMergeDelay) {
                return UndoManagerFactory.unlimitedHistorySingleChangeUM(changeStream, invert, apply, merge, isIdentity, preventMergeDelay);
            }

            @Override
            public <C> UndoManager<List<C>> createMultiChangeUM(EventStream<List<C>> changeStream, Function<? super C, ? extends C> invert, Consumer<List<C>> apply, BiFunction<C, C, Optional<C>> merge, Predicate<C> isIdentity, Duration preventMergeDelay) {
                return UndoManagerFactory.unlimitedHistoryMultiChangeUM(changeStream, invert, apply, merge, isIdentity, preventMergeDelay);
            }
        };
    }

    public static UndoManagerFactory fixedSizeHistoryFactory(final int capacity) {
        return new UndoManagerFactory(){

            @Override
            public <C> UndoManager<C> createSingleChangeUM(EventStream<C> changeStream, Function<? super C, ? extends C> invert, Consumer<C> apply, BiFunction<C, C, Optional<C>> merge, Predicate<C> isIdentity, Duration preventMergeDelay) {
                return UndoManagerFactory.fixedSizeHistorySingleChangeUM(changeStream, invert, apply, merge, isIdentity, preventMergeDelay, capacity);
            }

            @Override
            public <C> UndoManager<List<C>> createMultiChangeUM(EventStream<List<C>> changeStream, Function<? super C, ? extends C> invert, Consumer<List<C>> apply, BiFunction<C, C, Optional<C>> merge, Predicate<C> isIdentity, Duration preventMergeDelay) {
                return UndoManagerFactory.fixedSizeHistoryMultiChangeUM(changeStream, invert, apply, merge, isIdentity, preventMergeDelay, capacity);
            }
        };
    }

    public static UndoManagerFactory zeroHistoryFactory() {
        return new UndoManagerFactory(){

            @Override
            public <C> UndoManager<C> createSingleChangeUM(EventStream<C> changeStream, Function<? super C, ? extends C> invert, Consumer<C> apply, BiFunction<C, C, Optional<C>> merge, Predicate<C> isIdentity, Duration preventMergeDelay) {
                return UndoManagerFactory.zeroHistorySingleChangeUM(changeStream);
            }

            @Override
            public <C> UndoManager<List<C>> createMultiChangeUM(EventStream<List<C>> changeStream, Function<? super C, ? extends C> invert, Consumer<List<C>> apply, BiFunction<C, C, Optional<C>> merge, Predicate<C> isIdentity, Duration preventMergeDelay) {
                return UndoManagerFactory.zeroHistoryMultiChangeUM(changeStream);
            }
        };
    }
}

