/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.value;

import javafx.beans.value.ObservableValue;
import org.reactfx.Subscription;
import org.reactfx.value.Val;
import org.reactfx.value.ValBase;

class OrElse<T>
extends ValBase<T> {
    private final ObservableValue<? extends T> src;
    private final ObservableValue<? extends T> other;
    private boolean trySrc;

    OrElse(ObservableValue<? extends T> src, ObservableValue<? extends T> other) {
        this.src = src;
        this.other = other;
    }

    @Override
    protected Subscription connect() {
        this.trySrc = true;
        Subscription sub1 = Val.observeInvalidations(this.src, obs -> {
            this.trySrc = true;
            this.invalidate();
        });
        Subscription sub2 = Val.observeInvalidations(this.other, obs -> {
            if (!this.trySrc) {
                this.invalidate();
            }
        });
        return sub1.and(sub2);
    }

    @Override
    protected T computeValue() {
        if (!this.isObservingInputs()) {
            T val = this.src.getValue();
            return val != null ? val : this.other.getValue();
        }
        if (this.trySrc) {
            T val = this.src.getValue();
            if (val != null) {
                return val;
            }
            this.trySrc = false;
        }
        return this.other.getValue();
    }
}

