/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.m7.v6.listener;

import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.AbstractComXervExchangeConnection;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.Member;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.entities.session.Session;
import com.deutscheboerse.comxerv.comtrader.service.amqp.NotifyListenersObjectHandler;
import com.deutscheboerse.comxerv.comtrader.service.amqp.ObjectHandler;
import com.deutscheboerse.comxerv.comtrader.service.user.OnBehalfService;
import com.deutscheboerse.m7.trading.api.v6.MbrChangeRprt;
import java.util.Collection;
import java.util.Collections;

public class MbrChangeRprtObjectHandler
extends NotifyListenersObjectHandler<MbrChangeRprt> {
    private final OnBehalfService onBehalfService;
    private final AbstractComXervExchangeConnection connection;

    public MbrChangeRprtObjectHandler(ApplicationContext applicationContext, AbstractComXervExchangeConnection connection) {
        super(connection.getBroadcastHandler());
        this.connection = connection;
        this.onBehalfService = applicationContext.getService(OnBehalfService.class);
    }

    @Override
    public ObjectHandler.Result handleObject(Session session, MbrChangeRprt object, String correlationId) {
        ObjectHandler.Result result = super.handleObject(session, object, correlationId);
        User onBehalfUser = this.onBehalfService.getOnBehalfUser();
        if (onBehalfUser != null && onBehalfUser.getMemberId().equals(object.getMbrId())) {
            this.onBehalfService.reloadOnBehalfUser();
        }
        return result;
    }

    @Override
    public Collection<? extends BroadcastEntity> unpack(MbrChangeRprt object, Exchange exchange, String correlationId) {
        return Collections.singletonList(this.connection.getMapper().translate(Member.class, object));
    }
}

