/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.MarketArea;
import com.deutscheboerse.comxerv.comtrader.service.mapper.AbstractMapper;
import com.deutscheboerse.comxerv.comtrader.service.mapper.MapperHandler;
import com.deutscheboerse.m7.trading.api.v6.MktAreaListEntryType;

public class MarketAreaMapper
extends AbstractMapper<MktAreaListEntryType, MarketArea> {
    public MarketAreaMapper(ApplicationContext applicationContext, Exchange exchange) {
        super(applicationContext, exchange, MktAreaListEntryType.class, MarketArea.class);
    }

    @Override
    public MarketArea translate(MktAreaListEntryType from, MapperHandler mapperHandler, Object hint) {
        MarketArea marketArea = new MarketArea();
        marketArea.setId(from.getMktAreaId());
        marketArea.setName(from.getName());
        marketArea.setLongName(from.getLongName());
        marketArea.setRevisionNumber(from.getRevisionNo());
        this.applicationContext.getSmallDataModel(DeliveryArea.class).getAllEntitiesAsStream().filter(da -> da.getMarketAreaId().endsWith(from.getMktAreaId())).forEach(da -> da.setMarketArea(marketArea));
        return marketArea;
    }
}

