/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.core.datamodel;

import com.deutscheboerse.comxerv.comtrader.core.datamodel.AbstractDataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModelListener;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.type.ProductState;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import java.util.function.Consumer;

public class DataModelProductListener
extends AbstractDataModelListener<Product> {
    private Consumer<Product> productAdded;
    private Consumer<Product> productRemoved;
    private Runnable removeAll;

    public DataModelProductListener(Consumer<Product> productAdded, Consumer<Product> productRemoved, Runnable removeAll) {
        this.productAdded = productAdded;
        this.productRemoved = productRemoved;
        this.removeAll = removeAll;
    }

    @Override
    public DataModelListener.NotificationResult notifyAdd(Product product) {
        if (product.getProductState() == ProductState.ACTIVE) {
            FxUtil.runInFxThread(() -> this.productAdded.accept(product));
        }
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }

    @Override
    public DataModelListener.NotificationResult notifyRemove(Product product) {
        this.productRemoved.accept(product);
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }

    @Override
    public DataModelListener.NotificationResult notifyRemoveAll() {
        this.removeAll.run();
        return DataModelListener.NotificationResult.REMOVE_LISTENER;
    }

    @Override
    public DataModelListener.NotificationResult notifyUpdate(Product product) {
        if (product.getProductState() == ProductState.ACTIVE) {
            FxUtil.runInFxThread(() -> this.productAdded.accept(product));
        } else {
            this.productRemoved.accept(product);
        }
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }
}

