/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.datamodel.query;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataQuery;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.SmallFastDataModel;
import com.deutscheboerse.comxerv.comtrader.core.entity.EntityFilters;
import com.deutscheboerse.comxerv.comtrader.datamodel.query.SmallFastDataModelQuery;
import com.deutscheboerse.comxerv.comtrader.domain.query.OrderQueries;
import com.deutscheboerse.comxerv.comtrader.entities.BalancingGroup;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookEntries;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookEntry;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderStatus;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderType;
import com.deutscheboerse.comxerv.comtrader.service.OwnQuantityLookupService;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

@Singleton
class OrderQueriesImpl
implements OrderQueries {
    private final SmallFastDataModel<Long, Order> orderDataModel;
    private Map<String, Order> clientOrderIdIndex;
    private final ApplicationContext applicationContext;

    @Inject
    public OrderQueriesImpl(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.orderDataModel = applicationContext.getSmallDataModel(Order.class);
        this.clientOrderIdIndex = new ConcurrentHashMap<String, Order>();
        this.orderDataModel.registerHencePostOperationListener(new ClientOrderIdIndexUpdater());
    }

    @Override
    public DataQuery<Order> findActiveOrders() {
        return new SmallFastDataModelQuery<Long, Order>(this.orderDataModel).addFilter(EntityFilters.propertyEquals(Order::getStatus, OrderStatus.ACTIVE));
    }

    @Override
    public DataQuery<Order> findHibernateOrders() {
        return new SmallFastDataModelQuery<Long, Order>(this.orderDataModel).addFilter(EntityFilters.propertyEquals(Order::getStatus, OrderStatus.HIBERNATE));
    }

    @Override
    public Optional<Order> findOwnQuoteOrderForOrderbook(Orderbook orderbook, BalancingGroup balancingGroup, Direction direction) {
        OwnQuantityLookupService ownQuantityLookupService = this.applicationContext.getService(OwnQuantityLookupService.class);
        OrderbookEntries entries2 = direction == Direction.BUY ? orderbook.getBuys() : orderbook.getSells();
        return entries2.getEntries().stream().map(OrderbookEntry::getOrderId).map(this.orderDataModel::findById).filter(Objects::nonNull).filter(Order::isQuote).filter(ownQuantityLookupService::isOwnOrder).filter(order -> order.getBalancingGroup().equals(balancingGroup)).findFirst();
    }

    @Override
    public Optional<Order> findBestOrderForOrderbook(Orderbook orderbook, Direction direction) {
        OwnQuantityLookupService ownQuantityLookupService = this.applicationContext.getService(OwnQuantityLookupService.class);
        boolean isBuy = direction.isBuy();
        OrderbookEntries entries2 = isBuy ? orderbook.getBuys() : orderbook.getSells();
        return entries2.getSortedEntries().stream().map(OrderbookEntry::getOrderId).map(this.orderDataModel::findById).filter(Objects::nonNull).filter(order -> order.getDeliveryArea().equals(orderbook.getDeliveryArea())).filter(order -> !order.isQuote()).filter(order -> !OrderType.OTC_PREARRANGED.equals(order.getOrderType())).filter(ownQuantityLookupService::isOwnOrder).findFirst();
    }

    @Override
    public Optional<Order> findUnconfirmedByClientOrderId(String clientOrderId) {
        if (clientOrderId == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.clientOrderIdIndex.get(clientOrderId)).filter(order -> order.getStatus() == OrderStatus.MODI || order.getStatus() == OrderStatus.SENT || order.getStatus() == OrderStatus.ERROR);
    }

    @Override
    public Optional<Order> findActiveByClientOrderId(String clientOrderId) {
        if (clientOrderId == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.clientOrderIdIndex.get(clientOrderId)).filter(order -> order.getStatus() == OrderStatus.ACTIVE);
    }

    private class ClientOrderIdIndexUpdater
    implements DataModelListener<Order> {
        private ClientOrderIdIndexUpdater() {
        }

        @Override
        public DataModelListener.NotificationResult notifyAdd(Order object) {
            Order oldOne;
            String clientOrderId = object.getClientOrderId();
            if (clientOrderId != null && ((oldOne = OrderQueriesImpl.this.clientOrderIdIndex.get(clientOrderId)) == null || (Long)oldOne.getId() <= (Long)object.getId())) {
                OrderQueriesImpl.this.clientOrderIdIndex.put(clientOrderId, object);
            }
            return DataModelListener.NotificationResult.RETAIN_LISTENER;
        }

        @Override
        public DataModelListener.NotificationResult notifyAddAll(Collection<Order> objects) {
            objects.forEach(this::notifyAdd);
            return DataModelListener.NotificationResult.RETAIN_LISTENER;
        }

        @Override
        public DataModelListener.NotificationResult notifyRemove(Order object) {
            Order oldOne;
            String clientOrderId = object.getClientOrderId();
            if (clientOrderId != null && ((oldOne = OrderQueriesImpl.this.clientOrderIdIndex.get(clientOrderId)) == null || Objects.equals(oldOne.getId(), object.getId()))) {
                OrderQueriesImpl.this.clientOrderIdIndex.remove(clientOrderId);
            }
            return DataModelListener.NotificationResult.RETAIN_LISTENER;
        }

        @Override
        public DataModelListener.NotificationResult notifyRemoveAll(Collection<Order> objects) {
            objects.forEach(this::notifyRemove);
            return DataModelListener.NotificationResult.RETAIN_LISTENER;
        }

        @Override
        public DataModelListener.NotificationResult notifyRemoveAll() {
            OrderQueriesImpl.this.clientOrderIdIndex.clear();
            return DataModelListener.NotificationResult.RETAIN_LISTENER;
        }

        @Override
        public DataModelListener.NotificationResult notifyUpdate(Order object) {
            return DataModelListener.NotificationResult.RETAIN_LISTENER;
        }

        @Override
        public DataModelListener.NotificationResult notifyUpdateAll(Collection<Order> objects) {
            return DataModelListener.NotificationResult.RETAIN_LISTENER;
        }
    }
}

