/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities.orderbook;

import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.CommonOrderbookEntry;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookEntry;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookEntryType;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderType;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import com.deutscheboerse.ui.jfx.util.binding.ObservableBase;
import java.util.Comparator;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javax.annotation.Nonnull;

public class ExtendedOrderbookEntry
extends CommonOrderbookEntry {
    private final Long orderId;
    private final long serverTimestamp;
    private final BooleanProperty tradable;
    private final ObservableBase ownObservable;
    private final LongDisplayValue remainingQuantity;

    public ExtendedOrderbookEntry(OrderbookEntry rawEntry, long addedTimestamp, Orderbook orderbook, Direction direction, boolean isOwnOrder, boolean isOwnUserOrder, boolean tradable) {
        super(addedTimestamp, LongDisplayValue.ZERO, rawEntry.getPrice(), rawEntry.getQuantity(), LongDisplayValue.ZERO, orderbook, direction, rawEntry.getOrderType(), isOwnOrder, isOwnUserOrder, rawEntry.getOrderType() == OrderType.BALANCE);
        this.serverTimestamp = rawEntry.getTime().getMillis();
        this.orderId = rawEntry.getOrderId();
        this.tradable = new SimpleBooleanProperty(tradable);
        this.remainingQuantity = rawEntry.getRemainingQuantity();
        this.ownObservable = new ObservableBase();
    }

    protected static ExtendedOrderbookEntry createBinarySearchKey(OrderbookEntry rawEntry, Orderbook orderbook, Direction direction) {
        return new ExtendedOrderbookEntry(rawEntry, 0L, orderbook, direction, false, false, false);
    }

    public Long getOrderId() {
        return this.orderId;
    }

    public long getServerTimestamp() {
        return this.serverTimestamp;
    }

    public boolean getTradable() {
        return this.tradable.get();
    }

    public BooleanProperty tradableProperty() {
        return this.tradable;
    }

    public void setTradable(boolean tradable) {
        this.tradable.set(tradable);
    }

    @Override
    public LongDisplayValue getTradableQuantity() {
        return this.getTradable() ? this.getQuantity() : this.getQuantity().toZero();
    }

    @Override
    public LongDisplayValue getOwnQuantity() {
        return this.isContainsOwnOrder() ? this.remainingQuantity : this.remainingQuantity.toZero();
    }

    @Override
    public ObservableValue<LongDisplayValue> ownQuantityProperty() {
        return DependentBinding.get(this::getOwnQuantity, this.ownObservable);
    }

    public LongDisplayValue getRemainingQuantity() {
        return this.remainingQuantity;
    }

    @Override
    public OrderbookEntryType getType() {
        return OrderbookEntryType.NOT_AGGREGATED;
    }

    protected void invalidateOwnObservable() {
        this.ownObservable.invalidate();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtendedOrderbookEntry that = (ExtendedOrderbookEntry)o;
        return this.getOrderId().equals(that.getOrderId());
    }

    public int hashCode() {
        return this.getOrderId().hashCode();
    }

    public boolean isTradable() {
        return true;
    }

    @Override
    public String toString() {
        return "EOE{prc=" + String.valueOf(this.getPrice()) + ", qty=" + String.valueOf(this.getQuantity()) + ", ordId=" + this.getOrderId() + "}";
    }

    public String toLongString() {
        return "EOE{prc=" + String.valueOf(this.getPrice()) + ", qty=" + String.valueOf(this.getQuantity()) + ", firmQty=" + String.valueOf(this.getQuantity()) + ", accQty=" + String.valueOf(this.getAccQuantity()) + ", vwap=" + String.valueOf(this.getVwap()) + ", ownOrdr=" + this.isContainsOwnOrder() + ", ownUsrOrdr=" + this.isContainsOwnUserOrder() + ", balOrdr=" + this.isContainsBalOrder() + "}";
    }

    private static int compareTime(ExtendedOrderbookEntry o1, ExtendedOrderbookEntry o2) {
        int timestampComparison = Long.compare(o1.getServerTimestamp(), o2.getServerTimestamp());
        return timestampComparison == 0 ? Long.compare(o1.getOrderId(), o2.getOrderId()) : timestampComparison;
    }

    public static Comparator<ExtendedOrderbookEntry> getDefaultComparator(@Nonnull Direction direction) {
        return Direction.BUY.equals(direction) ? new PriceDescTimeAscComparator() : new PriceAscServerTimeAscComparator();
    }

    public static class PriceDescTimeAscComparator
    implements Comparator<ExtendedOrderbookEntry> {
        @Override
        public int compare(ExtendedOrderbookEntry o1, ExtendedOrderbookEntry o2) {
            int priceComparison = o2.getPrice().compareTo(o1.getPrice());
            return priceComparison == 0 ? ExtendedOrderbookEntry.compareTime(o1, o2) : priceComparison;
        }
    }

    public static class PriceAscServerTimeAscComparator
    implements Comparator<ExtendedOrderbookEntry> {
        @Override
        public int compare(ExtendedOrderbookEntry o1, ExtendedOrderbookEntry o2) {
            int priceComparison = o1.getPrice().compareTo(o2.getPrice());
            return priceComparison == 0 ? ExtendedOrderbookEntry.compareTime(o1, o2) : priceComparison;
        }
    }
}

