/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities.orderbook;

import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.ComputedOrderbookEntries;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.ExtendedOrderbookEntries;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.ExtendedOrderbookEntry;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.VWapUtil;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.listener.BatchUpdateAdapter;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.listener.BatchUpdateListener;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.listener.WeakBatchUpdateListener;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import com.deutscheboerse.comxerv.comtrader.entities.type.ExecutionRestriction;
import java.util.Collections;
import java.util.List;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.value.ObservableValue;

public class VWapBinding
extends ObjectBinding<LongDisplayValue> {
    private ObservableValue<LongDisplayValue> price;
    private ObservableValue<LongDisplayValue> quantity;
    private final Direction direction;
    private final ObservableValue<ExecutionRestriction> executionRestriction;
    private final List<List<ExtendedOrderbookEntry>> orderbooks;
    private final BatchUpdateListener<ExtendedOrderbookEntry> entriesChangedListener;
    private final boolean isBlockOrderbook;

    public VWapBinding(Orderbook orderbook, Direction direction, ObservableValue<LongDisplayValue> price, ObservableValue<LongDisplayValue> quantity, ObservableValue<ExecutionRestriction> executionRestriction) {
        this.direction = direction;
        this.isBlockOrderbook = orderbook.getContract().getType().isBlock();
        this.price = price;
        this.quantity = quantity;
        this.executionRestriction = executionRestriction;
        this.entriesChangedListener = BatchUpdateAdapter.batchFinishedListener(this::invalidate);
        List<ExtendedOrderbookEntries> orderbookEntrieses = this.isBlockOrderbook ? orderbook.getOrderbooksForVwapCalculation().stream().map(this::getEntries).toList() : Collections.singletonList(this.getEntries(orderbook));
        this.orderbooks = orderbookEntrieses.stream().map(ComputedOrderbookEntries::getEntries).toList();
        orderbookEntrieses.stream().forEach(entries2 -> entries2.addListener(new WeakBatchUpdateListener<ExtendedOrderbookEntry>(this.entriesChangedListener)));
        this.bind(price, quantity, executionRestriction);
    }

    private ExtendedOrderbookEntries getEntries(Orderbook orderbook) {
        return this.direction.isBuy() ? orderbook.getExtendedSells() : orderbook.getExtendedBuys();
    }

    @Override
    protected LongDisplayValue computeValue() {
        if (this.isBlockOrderbook) {
            return VWapUtil.computeBlockVwap(this.price.getValue(), this.quantity.getValue(), this.orderbooks);
        }
        return VWapUtil.computeVwap(this.price.getValue(), this.quantity.getValue(), this.direction, this.orderbooks.get(0), this.executionRestriction.getValue());
    }
}

