/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx;

import com.deutscheboerse.comxerv.comtrader.app.login.MasterLoginWindow;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.datamodel.query.QueriesModule;
import com.deutscheboerse.comxerv.comtrader.entities.FullTrade;
import com.deutscheboerse.comxerv.comtrader.entities.session.Session;
import com.deutscheboerse.comxerv.comtrader.jfx.GuiMessageRecorder;
import com.deutscheboerse.comxerv.comtrader.jfx.components.mainpanel.GlobalKeyboardShortcuts;
import com.deutscheboerse.comxerv.comtrader.jfx.module.JfxServiceModule;
import com.deutscheboerse.comxerv.comtrader.jfx.module.JfxUiModule;
import com.deutscheboerse.comxerv.comtrader.jfx.module.SingleLoginModule;
import com.deutscheboerse.comxerv.comtrader.jfx.util.AmqpWorkInFxThreadLogger;
import com.deutscheboerse.comxerv.comtrader.jfx.util.FxDelaySensor;
import com.deutscheboerse.comxerv.comtrader.jfx.util.StuckApplicationGuard;
import com.deutscheboerse.comxerv.comtrader.module.CoreModule;
import com.deutscheboerse.comxerv.comtrader.module.DynamicModule;
import com.deutscheboerse.comxerv.comtrader.module.RemoteServiceModule;
import com.deutscheboerse.comxerv.comtrader.module.ServiceModule;
import com.deutscheboerse.comxerv.comtrader.module.WorkerExecutor;
import com.deutscheboerse.comxerv.comtrader.monitoring.Monitor;
import com.deutscheboerse.comxerv.comtrader.service.ApplicationConfigurationService;
import com.deutscheboerse.comxerv.comtrader.service.BackendConnectionGateway;
import com.deutscheboerse.comxerv.comtrader.service.InitialLoadingService;
import com.deutscheboerse.comxerv.comtrader.service.LocalService;
import com.deutscheboerse.comxerv.comtrader.service.UserAlertService;
import com.deutscheboerse.comxerv.comtrader.service.event.ApplicationShutdownEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.EntityAdditionalLoadingFinishedEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.LoadingStartedEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.OwnUserLoadedEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.UserDataResetEvent;
import com.deutscheboerse.comxerv.comtrader.service.info.InfoLogger;
import com.deutscheboerse.comxerv.comtrader.service.performancemonitoring.PerformanceLoggingService;
import com.deutscheboerse.comxerv.comtrader.service.profile.ProfileMigrationModule;
import com.deutscheboerse.comxerv.comtrader.service.question.LogoutErrorConfirmation;
import com.deutscheboerse.comxerv.comtrader.service.version.VersionService;
import com.deutscheboerse.comxerv.comtrader.util.Bootstrap;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.comxerv.comtrader.util.concurrent.ConcurrencyUtil;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javafx.application.Application;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComTraderApplication
extends Application {
    private static final Logger LOG = LoggerFactory.getLogger(ComTraderApplication.class);
    private final ApplicationContext appContext;
    private final AtomicBoolean isStoppedSync = new AtomicBoolean(false);
    private final FxDelaySensor fxDelaySensor;
    private final StuckApplicationGuard stuckApplicationGuard;

    public ComTraderApplication() {
        System.setProperty("com.google.inject.internal.cglib.$experimental_asm7", "true");
        this.appContext = this.createInjector().getInstance(ApplicationContext.class);
        this.fxDelaySensor = new FxDelaySensor(this.appContext.getService(Monitor.class));
        this.stuckApplicationGuard = new StuckApplicationGuard(this::forceShutDown, this.appContext);
    }

    protected ComTraderApplication(ApplicationContext appContext, FxDelaySensor fxDelaySensor, StuckApplicationGuard stuckApplicationGuard) {
        this.appContext = appContext;
        this.fxDelaySensor = fxDelaySensor;
        this.stuckApplicationGuard = stuckApplicationGuard;
    }

    public static void main(String[] args2) {
        ComTraderApplication.launch(args2);
    }

    private Injector createInjector() {
        return Guice.createInjector(new CoreModule(), new ServiceModule(), new ProfileMigrationModule(), new QueriesModule(), new JfxServiceModule(), new JfxUiModule(), new RemoteServiceModule(), new SingleLoginModule(Bootstrap.getConnectionParameters()), new DynamicModule());
    }

    @Override
    public void init() {
        this.javaCheck();
        this.startLogging();
        this.loadLocale();
        this.registerUncaughtExceptionHandlers();
        this.registerShutdownHook();
        this.registerPerformanceLoggingShortcut();
        this.getEventBus().register(this);
        this.stuckApplicationGuard.start();
        this.fxDelaySensor.start();
    }

    @Override
    public void start(Stage primaryStage) {
        this.getBackendConnectionGateway().addMessageInterceptor(this.appContext.getService(GuiMessageRecorder.class));
        this.getBackendConnectionGateway().addMessageInterceptor(new AmqpWorkInFxThreadLogger());
        this.appContext.getService(MasterLoginWindow.class).showLoginWindow();
    }

    @Override
    public void stop() {
        if (this.isStoppedSync.compareAndSet(false, true)) {
            try {
                this.getEventBus().unregister(this.appContext.getService(MasterLoginWindow.class));
                this.appContext.getService(ExecutorService.class, WorkerExecutor.class).submit(() -> this.getBackendConnectionGateway().logout(new LogoutErrorConfirmation(this.appContext.getService(UserAlertService.class))));
                LOG.info("Application successfully stopped");
                this.getEventBus().post(new ApplicationShutdownEvent());
            }
            finally {
                this.startKillerThread();
                this.fxDelaySensor.stop();
                this.stuckApplicationGuard.stop();
            }
        }
    }

    private void loadLocale() {
        Locale configuredLocale = this.appContext.getService(LocalService.class).getConfiguredLocale();
        LOG.info("Set Locale: {}", (Object)configuredLocale);
        Util.setLocale(configuredLocale);
        Locale.setDefault(configuredLocale);
    }

    private void startLogging() {
        this.logCommandLineArguments();
        ScheduledExecutorService executor = this.appContext.getService(ScheduledExecutorService.class, WorkerExecutor.class);
        InfoLogger infoLogger = this.appContext.getService(InfoLogger.class);
        infoLogger.logStartUpInfo();
        executor.scheduleAtFixedRate(infoLogger::logSystemInfo, 0L, 5L, TimeUnit.MINUTES);
        executor.scheduleAtFixedRate(infoLogger::logPerformanceInfo, 1000L, 1000L, TimeUnit.MILLISECONDS);
        executor.scheduleAtFixedRate(infoLogger::logResourceInfo, 60L, 60L, TimeUnit.SECONDS);
    }

    private BackendConnectionGateway getBackendConnectionGateway() {
        return this.appContext.getService(BackendConnectionGateway.class);
    }

    private void registerUncaughtExceptionHandlers() {
        FxUtil.runInFxThread(() -> {
            Thread.currentThread().setUncaughtExceptionHandler((t, e) -> LOG.error("FX-thread", e));
            Thread.setDefaultUncaughtExceptionHandler((t, e) -> LOG.error(t.getName(), e));
        });
    }

    protected void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(this::forceShutDown));
    }

    private void registerPerformanceLoggingShortcut() {
        GlobalKeyboardShortcuts globalKeyboardShortcuts = this.appContext.getService(GlobalKeyboardShortcuts.class);
        PerformanceLoggingService performanceLoggingService = this.appContext.getService(PerformanceLoggingService.class);
        globalKeyboardShortcuts.registerKeyboardShortcut(performanceLoggingService::togglePerformanceLogging, new KeyCodeCombination(KeyCode.L, KeyCombination.CONTROL_DOWN, KeyCombination.ALT_DOWN, KeyCombination.SHIFT_DOWN));
        if (this.appContext.getService(ApplicationConfigurationService.class).getBooleanApplicationProperty("withPerformanceLogging")) {
            performanceLoggingService.togglePerformanceLogging();
        }
    }

    private void forceShutDown() {
        if (this.isStoppedSync.compareAndSet(false, true)) {
            this.startKillerThread();
            this.fxDelaySensor.stop();
            this.stuckApplicationGuard.stop();
            this.getBackendConnectionGateway().closeConnection();
        }
    }

    private EventBus getEventBus() {
        return this.appContext.getService(EventBus.class);
    }

    protected void startKillerThread() {
        try (ScheduledExecutorService killerExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Comtrader-Timed-Killer").build());){
            killerExecutor.schedule(() -> {
                LOG.error("Still active non-daemon threads:");
                LOG.error(ConcurrencyUtil.dumpAllThreads(true));
                LOG.error("The application has not terminated normally, using System.exit()");
                System.exit(-1);
            }, 10L, TimeUnit.SECONDS);
        }
    }

    @Subscribe
    public void handleLogin(OwnUserLoadedEvent loginEvent) {
        this.handleLogin(loginEvent.getSession());
    }

    @Subscribe
    public void handleLogin(UserDataResetEvent userDataResetEvent) {
        this.handleLogin(userDataResetEvent.getSession());
    }

    @Subscribe
    public void handleLoadingStartedEvent(LoadingStartedEvent loadingStartedEvent) {
        this.stuckApplicationGuard.setExpectedLoad(StuckApplicationGuard.ExpectedLoad.HIGH);
    }

    @Subscribe
    public void handleFullTradeAdditionalLoadingFinishedEvent(EntityAdditionalLoadingFinishedEvent<FullTrade> entityAdditionalLoadingFinishedEvent) {
        this.stuckApplicationGuard.setExpectedLoad(StuckApplicationGuard.ExpectedLoad.NORMAL);
    }

    private void handleLogin(Session session) {
        InitialLoadingService loadingService = this.appContext.getService(InitialLoadingService.class, session.getExchange());
        loadingService.doInitialLoad(session.getExchange());
        this.appContext.getService(GuiMessageRecorder.class).setRabbitUser(session.getConnectionParameters().getRabbitUser());
    }

    protected ApplicationContext getAppContext() {
        return this.appContext;
    }

    protected void logCommandLineArguments() {
        if (LOG.isInfoEnabled()) {
            RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
            LOG.info("Startup jvm parameters: {}", (Object)runtimeMxBean.getInputArguments().stream().collect(Collectors.joining(",")));
            Application.Parameters parameters = this.getParameters();
            if (parameters != null) {
                LOG.info("Startup application parameters: {}", (Object)parameters.getRaw().stream().collect(Collectors.joining(",")));
            }
        }
    }

    protected void javaCheck() {
        Runtime.Version javaRuntimeVersion = this.appContext.getService(VersionService.class).getJavaVersion();
        Runtime.Version comtraderJavaMinVersion = Runtime.Version.parse(this.appContext.getService(ApplicationConfigurationService.class).getApplicationProperty("comtrader.java.minVersion"));
        Integer comtraderJavaMaxVersion = this.appContext.getService(ApplicationConfigurationService.class).getIntegerApplicationProperty("comtrader.java.maxVersion", javaRuntimeVersion.feature());
        if (javaRuntimeVersion.feature() > comtraderJavaMaxVersion || javaRuntimeVersion.compareTo(comtraderJavaMinVersion) < 0) {
            LOG.error("Unsupported java version detected {}! Required java version is {} (minimal {}), or max {}", javaRuntimeVersion, comtraderJavaMinVersion.feature(), comtraderJavaMinVersion, comtraderJavaMaxVersion);
            System.exit(1);
        }
    }
}

