/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components;

import com.deutscheboerse.comxerv.comtrader.app.login.StorableComponent;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.domain.query.OrderbookQueries;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.jfx.components.AbstractPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.PanelWithLoadingIndicator;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.LimitChoiceBox;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.toolbar.BottomToolbar;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.AbstractOrderbookPane;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.CloseRemoveOrderbookCallBack;
import com.deutscheboerse.comxerv.comtrader.jfx.components.singlecontract.SingleContractOrderbookPanelState;
import com.deutscheboerse.comxerv.comtrader.jfx.service.csv.ImportExportService;
import com.deutscheboerse.comxerv.comtrader.jfx.service.event.SingleContractOrderbookEvent;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.deutscheboerse.ui.jfx.util.event.KeyEventUtil;
import com.google.common.eventbus.Subscribe;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.InvalidationListener;
import javafx.fxml.FXML;
import javafx.scene.control.TitledPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import org.joda.time.LocalDate;

@PanelWithLoadingIndicator(entityClasses={Orderbook.class})
public abstract class AbstractMagnifiedOrderbookPanel
extends AbstractPanel
implements StorableComponent<SingleContractOrderbookPanelState>,
CloseRemoveOrderbookCallBack {
    private static final int MIN_ROWS = 100;
    private static final int DEFAULT_MAGNIFIED_ORDERBOOK_DEPTH = -1;
    private final ImportExportService importExportService;
    private final OrderbookQueries orderbookQueries;
    private AbstractOrderbookPane orderbookPane;
    @FXML
    private BottomToolbar bottomToolbar;
    @FXML
    private TitledPane menu;
    @FXML
    private BorderPane centerBorderPane;
    @FXML
    protected LimitChoiceBox limitChoiceBox;
    private InvalidationListener filterOrderbooksListener = observable2 -> FxUtil.runInFxThread(() -> this.getCurrentOrderbook().ifPresent(this::setOrderbook));

    public AbstractMagnifiedOrderbookPanel(ApplicationContext appContext) {
        super(appContext);
        this.importExportService = appContext.getService(ImportExportService.class);
        this.orderbookQueries = appContext.getService(OrderbookQueries.class);
        this.loadFxml();
        this.addEventFilter(KeyEvent.KEY_PRESSED, (? super T keyEvent) -> {
            if (KeyEventUtil.isCtrlAltKeyCode(KeyCode.C, keyEvent)) {
                this.exportClipboard();
                keyEvent.consume();
            } else if (KeyEventUtil.isCtrlKeyCode(KeyCode.E, keyEvent)) {
                this.exportCSV();
                keyEvent.consume();
            }
        });
        this.limitChoiceBox.setValue(-1);
    }

    private Optional<Orderbook> getCurrentOrderbook() {
        if (this.getOrderbookPane() != null && this.getOrderbookPane().getOrderbook() != null) {
            Orderbook orderbook = this.getOrderbookPane().getOrderbook();
            return this.orderbookQueries.findByContractAndDeliveryArea(orderbook.getContract(), orderbook.getDeliveryArea());
        }
        return Optional.empty();
    }

    public AbstractOrderbookPane getOrderbookPane() {
        return this.orderbookPane;
    }

    @Subscribe
    public void handleSelectionEvent(SingleContractOrderbookEvent event) {
        if (Objects.equals(this.getContentTab(), this.getContentTabLookup().findContentTabOfNode(event.getEventSource()))) {
            this.setOrderbook(event.getOrderbook());
            event.markProcessed();
        }
    }

    protected abstract AbstractOrderbookPane createOrderbookPane(Orderbook var1);

    private void setOrderbook(Orderbook orderbook) {
        if (this.orderbookPane != null) {
            this.orderbookPane.orderbookProperty().removeListener(this.filterOrderbooksListener);
        }
        if (orderbook != null) {
            if (this.orderbookPane == null) {
                this.orderbookPane = this.createOrderbookPane(orderbook);
                this.orderbookPane.setVisibilityOfCloseButton(false);
                this.orderbookPane.setCollapsible(false);
            }
            this.orderbookPane.orderbookProperty().addListener(this.filterOrderbooksListener);
            this.orderbookPane.orderbookProperty().setValue(orderbook);
        } else {
            this.orderbookPane = null;
        }
        this.centerBorderPane.setCenter(this.orderbookPane);
        if (this.orderbookPane != null) {
            this.orderbookPane.setMinRows(100);
        }
    }

    @Override
    public void closeOrderbookPane(AbstractOrderbookPane abstractOrderbookPane) {
        this.setOrderbook(null);
    }

    @Override
    public void removeOrHideOrderbook(Orderbook orderbook) {
        this.setOrderbook(null);
    }

    @Override
    public SingleContractOrderbookPanelState getComponentState() {
        String orderbookId = this.getCurrentOrderbook().isPresent() ? (String)this.getCurrentOrderbook().get().getId() : null;
        return new SingleContractOrderbookPanelState((Integer)this.limitChoiceBox.getValue(), this.menu.isExpanded(), this.bottomToolbar.getState(), orderbookId);
    }

    @Override
    public void restoreComponentState(SingleContractOrderbookPanelState componentState) {
        this.menu.setExpanded(componentState.isMenuExpanded());
        this.bottomToolbar.applyToolbarItemState(componentState.getBottomToolbarStoredState());
        this.limitChoiceBox.setValue(componentState.getOrderbookDepth());
        this.setOrderbook((Orderbook)this.getAppContext().getSmallDataModel(Orderbook.class).findById(componentState.getOrderbookId()));
    }

    @FXML
    public void exportCSV() {
        this.importExportService.exportOrderbookPanesToCsvFile(this.prepareExportData(), this.getScene().getWindow(), this.getFileName().replace(" ", "_"));
    }

    @FXML
    public void exportClipboard() {
        this.importExportService.exportOrderbookPanesToClipboard(this.prepareExportData());
    }

    private String getFileName() {
        LocalDate now = LocalDate.now();
        return now.toString("yyyy-MM-dd") + "-" + this.getComponentName();
    }

    private List<AbstractOrderbookPane> prepareExportData() {
        return this.orderbookPane != null ? Collections.singletonList(this.orderbookPane) : Collections.emptyList();
    }

    public BottomToolbar getBottomToolbar() {
        return this.bottomToolbar;
    }
}

