/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components;

import com.deutscheboerse.comxerv.comtrader.app.login.StorableComponent;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderStatus;
import com.deutscheboerse.comxerv.comtrader.jfx.components.ExportableAbstractPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.toolbar.BottomToolbar;
import com.deutscheboerse.comxerv.comtrader.jfx.components.order.OrderPanelState;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.CustomTableView;
import com.deutscheboerse.comxerv.comtrader.service.UserAlertService;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseHandler;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.OrderSender;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.OrdersToSend;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.RequestType;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.validation.CommonOrderValidationService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.validation.OrderValidationService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.validation.ValidationMode;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.TableView;
import javafx.scene.control.TitledPane;
import javafx.scene.input.TransferMode;

public abstract class AbstractOrderPanel
extends ExportableAbstractPanel<Order>
implements StorableComponent<OrderPanelState> {
    private static final int DEFAULT_ORDER_TIMEOUT = 30000;
    private static final int SINGLE_ORDER_EXPECTED_PROCESSING_TIME = 50;
    private final OrderSender orderSender;
    private final ObservableValue<User> currentUser;
    private final OrderValidationService validationService;
    private final UserAlertService userAlertService;
    private final InvalidationListener userChange;
    @FXML
    protected CustomTableView<Order> orderTableView;
    @FXML
    protected TitledPane menu;
    @FXML
    protected BottomToolbar bottomToolbar;

    protected AbstractOrderPanel(ApplicationContext appContext) {
        super(appContext);
        this.orderSender = appContext.getService(OrderSender.class);
        this.validationService = appContext.getService(OrderValidationService.class);
        this.userAlertService = appContext.getService(UserAlertService.class);
        this.currentUser = appContext.getService(UserService.class).currentUserProperty();
        this.userChange = observable2 -> this.userChanged();
        this.currentUser.addListener(new WeakInvalidationListener(this.userChange));
    }

    protected abstract void userChanged();

    @Override
    public void initialize() {
        super.initialize();
        this.orderTableView.setOnDragOver(dragEvent -> {
            dragEvent.acceptTransferModes(TransferMode.NONE);
            dragEvent.consume();
        });
        this.orderTableView.setOnDragDropped(dragEvent -> {
            dragEvent.acceptTransferModes(TransferMode.NONE);
            dragEvent.consume();
        });
    }

    @FXML
    public void activateSelectedOrdersButtonClickAction() {
        ArrayList<Order> orders = new ArrayList<Order>(this.orderTableView.getSelectionModel().getSelectedItems());
        StringBuilder errorsText = new StringBuilder();
        List<Order> invalidOrders = orders.stream().filter(order -> {
            OrderValidationService.ValidationResult validationResult = this.validationService.validateOrder((Order)order, ValidationMode.ORDERENTRY);
            if (validationResult.getResult() != CommonOrderValidationService.ValidationFlag.SUBMIT) {
                for (String key : validationResult.getLocalizedErrorMessageKeys()) {
                    if (errorsText.length() > 0) {
                        errorsText.append("\n");
                    }
                    errorsText.append(Util.getLabel("commons_orderId", validationResult.getParameters(key)) + " " + String.valueOf(order.getId()) + ": " + Util.getLabel(key, validationResult.getParameters(key)));
                }
                return true;
            }
            return false;
        }).toList();
        if (!invalidOrders.isEmpty()) {
            if (this.userAlertService.showQuestionDialog(Util.getLabel("ownOrderPanel_activateOnlyValidOrders_header"), Util.getLabel("ownOrderPanel_activateOnlyValidOrders"), errorsText.toString(), true, UserAlertService.Flag.OK_CANCEL, UserAlertService.Flag.INFO)) {
                this.sendRequest(RequestType.ACTIVATE, orders.stream().filter(order -> !invalidOrders.contains(order)).toList());
            }
        } else {
            this.sendRequest(RequestType.ACTIVATE, orders);
        }
        this.orderTableView.getSelectionModel().clearSelection();
    }

    @FXML
    public void deactivateSelectedOrdersButtonClickAction() {
        this.sendRequest(RequestType.DEACTIVATE, this.orderTableView.getSelectionModel().getSelectedItems());
        this.orderTableView.getSelectionModel().clearSelection();
    }

    protected void deactivateAllOrder() {
        List<Order> orders = this.orderTableView.getItems().stream().filter(o -> o.getStatus() == OrderStatus.ACTIVE).toList();
        if (!orders.isEmpty()) {
            this.orderSender.sendOrder(new OrdersToSend(orders, RequestType.DEACTIVATE, ResponseHandler.EMPTY), false, Math.max(30000, orders.size() * 50));
        }
    }

    protected void sendRequest(RequestType requestType, Collection<Order> orders) {
        boolean handleReselection;
        boolean bl = handleReselection = requestType == RequestType.MODIFY || requestType == RequestType.ACTIVATE;
        if (!orders.isEmpty()) {
            if (handleReselection) {
                this.orderTableView.getSelectionModel().clearSelection();
            }
            this.orderSender.sendOrder(new OrdersToSend(orders, requestType, ResponseHandler.EMPTY), false, Math.max(30000, orders.size() * 50));
        }
    }

    @Override
    public void restoreComponentState(OrderPanelState componentState) {
        componentState.getOrderTableViewDescriptor().applyToTable(this.orderTableView);
        this.menu.setExpanded(componentState.isMenuExpanded());
        this.bottomToolbar.applyToolbarItemState(componentState.getBottomToolbarStoredState());
    }

    @Override
    public TableView<Order> getTableView() {
        return this.orderTableView;
    }

    public BottomToolbar getBottomToolbar() {
        return this.bottomToolbar;
    }

    public void setBottomToolbar(BottomToolbar bottomToolbar) {
        this.bottomToolbar = bottomToolbar;
    }

    @FXML
    public void deleteSelectedOrdersButtonClickAction() {
        Map<Boolean, List<Order>> ordersToDelete = this.orderTableView.getSelectionModel().getSelectedItems().stream().collect(Collectors.partitioningBy(order -> order.getStatus() == OrderStatus.ERROR));
        this.getAppContext().getDataModel(Order.class).removeAll((Collection<Order>)ordersToDelete.get(true));
        this.sendRequest(RequestType.DELETE, (Collection<Order>)ordersToDelete.get(false));
        this.orderTableView.getSelectionModel().clearSelection();
    }
}

