/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components;

import com.deutscheboerse.comxerv.comtrader.app.login.StorableComponent;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.domain.query.MarketStateQueries;
import com.deutscheboerse.comxerv.comtrader.entities.BasketEntry;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.type.BasketRestriction;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import com.deutscheboerse.comxerv.comtrader.entities.type.MarketStatus;
import com.deutscheboerse.comxerv.comtrader.entities.type.MessageSeverity;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderStatus;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderType;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.DraggableComponent;
import com.deutscheboerse.comxerv.comtrader.jfx.components.ExportableAbstractPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.basket.BasketPanelState;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.bottomtoolbar.TotalsCounter;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.toolbar.BottomToolbar;
import com.deutscheboerse.comxerv.comtrader.jfx.components.mainpanel.GlobalKeyboardShortcuts;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.OrderPopup;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.CustomTableView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.order.BasketOrderRowFactory;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.storage.StorableTableLayoutDescriptor;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfiguration;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfigurations;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.gui.KeyboardShortcutsOverrideGuiStrategy;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.gui.TableViewOverrideGuiStrategy;
import com.deutscheboerse.comxerv.comtrader.jfx.service.csv.ImportExportService;
import com.deutscheboerse.comxerv.comtrader.jfx.util.DragAndDropService;
import com.deutscheboerse.comxerv.comtrader.service.MessagePublisher;
import com.deutscheboerse.comxerv.comtrader.service.UserAlertService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.OrderSender;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.OrdersToSend;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.RequestType;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.basket.Basket;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.basket.BasketFullException;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.basket.BasketService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.protection.OrderEntryProtectionService;
import com.deutscheboerse.comxerv.comtrader.service.trade.TradingSettingsService;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.event.KeyEventUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.RadioButton;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableView;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.TransferMode;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DraggableComponent(hasPublicAccess=true, nameKey="basketPanel_panelHeaderLabel", descriptionKey="basketPanel_description")
@OverrideGuiConfigurations(value={@OverrideGuiConfiguration(field="tableView", overrideId="BasketPanel", strategy=TableViewOverrideGuiStrategy.class), @OverrideGuiConfiguration(field="keyboardShortcutHandles", overrideId="Shortcuts", strategy=KeyboardShortcutsOverrideGuiStrategy.class)})
public class BasketPanel
extends ExportableAbstractPanel<BasketEntry>
implements StorableComponent<BasketPanelState> {
    private static final Logger LOG = LoggerFactory.getLogger(BasketPanel.class);
    private final UserService userService = this.getAppContext().getService(UserService.class);
    private final OrderSender orderSender = this.getAppContext().getService(OrderSender.class);
    private final DragAndDropService dragAndDropService = this.getAppContext().getService(DragAndDropService.class);
    private final Basket basket;
    private final ObservableList<BasketEntry> entries;
    private final MessagePublisher messagePublisher;
    private final MarketStateQueries marketStateQueries;
    private final UserAlertService userAlertService;
    private final OrderEntryProtectionService orderEntryProtectionService;
    private final TradingSettingsService tradingSettingsService;
    private final ObjectProperty<Integer> itemsCount;
    @FXML
    private CustomTableView<BasketEntry> basketTable;
    @FXML
    private TotalsCounter totalsCounter;
    @FXML
    private ToggleGroup basketRestrictionToggleGroup;
    @FXML
    private RadioButton noneBasketRestriction;
    @FXML
    private RadioButton validBasketRestriction;
    @FXML
    private RadioButton linkedBasketRestriction;
    @FXML
    private Button deleteButton;
    @FXML
    private Button submitButton;
    @FXML
    private Button editButton;
    @FXML
    private Button resetButton;
    @FXML
    private Button switchAllToFOKButton;
    @FXML
    private BasketOrderRowFactory basketOrderRowFactory;
    @FXML
    private TitledPane menu;
    @FXML
    private BottomToolbar bottomToolbar;
    private final GlobalKeyboardShortcuts.KeyboardShortcutHandle submitBasketShortcutHandle;
    private final ChangeListener<Boolean> linkedRestrictionAllowedChangeListener;
    private final ChangeListener<BasketRestriction> restrictionChangeListener;

    public BasketPanel() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public BasketPanel(ApplicationContext appContext) {
        super(appContext);
        this.messagePublisher = appContext.getService(MessagePublisher.class);
        this.marketStateQueries = appContext.getService(MarketStateQueries.class);
        this.userAlertService = appContext.getService(UserAlertService.class);
        this.orderEntryProtectionService = appContext.getService(OrderEntryProtectionService.class);
        this.tradingSettingsService = appContext.getService(TradingSettingsService.class);
        this.basket = this.getAppContext().getService(BasketService.class).getActiveBasket();
        this.entries = this.basket.getEntries();
        this.itemsCount = new SimpleObjectProperty<Integer>(0);
        this.linkedRestrictionAllowedChangeListener = this::linkedRestrictionAllowedChanged;
        this.restrictionChangeListener = this::restrictionChanged;
        this.submitBasketShortcutHandle = appContext.getService(GlobalKeyboardShortcuts.class).registerConditionalKeyboardShortcut(this::submit, new KeyCodeCombination(KeyCode.ENTER, KeyCombination.CONTROL_DOWN, KeyCombination.ALT_DOWN), this::isSubmittable);
        this.loadFxml();
    }

    @Override
    public void initialize() {
        SortedList<BasketEntry> sortedEntries = new SortedList<BasketEntry>(this.entries);
        sortedEntries.comparatorProperty().bind(this.basketTable.comparatorProperty());
        this.basketTable.setItems(sortedEntries);
        this.basketTable.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.deleteButton.disableProperty().bind(Bindings.isEmpty(this.basketTable.getSelectionModel().getSelectedIndices()));
        this.submitButton.disableProperty().bind(this.basket.submittable().not());
        this.editButton.disableProperty().bind(Bindings.size(this.basketTable.getSelectionModel().getSelectedIndices()).isNotEqualTo(1));
        this.resetButton.disableProperty().bind(Bindings.isEmpty(this.entries));
        this.noneBasketRestriction.setUserData((Object)BasketRestriction.NONE);
        this.validBasketRestriction.setUserData((Object)BasketRestriction.VLD);
        this.linkedBasketRestriction.setUserData((Object)BasketRestriction.LNK);
        this.switchAllToFOKButton.disableProperty().bind(this.basket.switchAllToFOKDisabled());
        this.basketRestrictionToggleGroup.selectedToggleProperty().addListener((observable2, oldValue, newValue) -> this.basket.restrictionProperty().set(newValue != null ? (BasketRestriction)((Object)((Object)newValue.getUserData())) : BasketRestriction.NONE));
        this.basket.restrictionProperty().addListener(new WeakChangeListener<BasketRestriction>(this.restrictionChangeListener));
        this.linkedBasketRestriction.disableProperty().bind(this.basket.linkedRestrictionAllowed().not());
        this.basketTable.setOnDragOver(event -> {
            if (this.hasRelevantContent((DragEvent)event)) {
                event.acceptTransferModes(TransferMode.ANY);
            }
            event.consume();
        });
        this.basketTable.setOnDragDropped(event -> {
            boolean droppedAnything = false;
            Dragboard db = event.getDragboard();
            try {
                droppedAnything = this.dropOrders(db);
            }
            catch (BasketFullException e) {
                this.messagePublisher.publishMessage(Util.getLabel("basketFullMessage", e.getAllowed()), MessageSeverity.ERROR);
                droppedAnything = true;
            }
            event.setDropCompleted(droppedAnything);
            event.consume();
        });
        this.basketTable.getItems().addListener(c -> this.itemsCount.setValue(this.basketTable.getItems().size()));
        this.basket.linkedRestrictionAllowed().addListener(new WeakChangeListener<Boolean>(this.linkedRestrictionAllowedChangeListener));
        this.addEventFilter(KeyEvent.KEY_PRESSED, (? super T keyEvent) -> {
            if (KeyEventUtil.isCtrlKeyCode(KeyCode.V, keyEvent)) {
                this.importClipboard();
                keyEvent.consume();
            }
        });
        this.restrictionChanged(this.basket.restrictionProperty(), null, (BasketRestriction)((Object)this.basket.restrictionProperty().getValue()));
        this.itemsCount.setValue(this.basketTable.getItems().size());
        this.totalsCounter.totalItemsProperty().bind(this.itemsCount);
        this.totalsCounter.shownItemsProperty().bind(this.itemsCount);
        super.initialize();
    }

    private void restrictionChanged(ObservableValue<? extends BasketRestriction> observableValue, BasketRestriction oldValue, BasketRestriction newValue) {
        switch (newValue) {
            case LNK: {
                this.basketRestrictionToggleGroup.selectToggle(this.linkedBasketRestriction);
                return;
            }
            case VLD: {
                this.basketRestrictionToggleGroup.selectToggle(this.validBasketRestriction);
                return;
            }
        }
        this.basketRestrictionToggleGroup.selectToggle(this.noneBasketRestriction);
    }

    private void linkedRestrictionAllowedChanged(ObservableValue<? extends Boolean> observable2, Boolean oldValue, Boolean newValue) {
        if (!newValue.booleanValue() && this.linkedBasketRestriction.equals(this.basketRestrictionToggleGroup.getSelectedToggle())) {
            this.basketRestrictionToggleGroup.selectToggle(this.noneBasketRestriction);
        }
    }

    @Override
    public TableView<BasketEntry> getTableView() {
        return this.basketTable;
    }

    private boolean dropOrders(Dragboard db) throws BasketFullException {
        boolean hasBasicOrderbookEntryList = this.dragAndDropService.hasBasicOrderbookEntryList(db);
        boolean hasOrderList = this.dragAndDropService.hasOrderList(db);
        if (hasOrderList || hasBasicOrderbookEntryList) {
            List<Order> orderList = hasOrderList ? this.dragAndDropService.getOrderList(db) : this.dragAndDropService.getBasicOrderbookEntryList(db);
            for (Order order : orderList) {
                if (this.userService.getOwnUser() == null) continue;
                this.basket.add(this.getActiveCopyOfOrder(order));
            }
            return true;
        }
        return false;
    }

    private boolean hasRelevantContent(DragEvent event) {
        Dragboard db = event.getDragboard();
        return this.dragAndDropService.hasOrderList(db) || this.dragAndDropService.hasBasicOrderbookEntryList(db);
    }

    private Order getActiveCopyOfOrder(Order order) {
        Order copy = new Order(order);
        copy.setStatus(OrderStatus.ACTIVE);
        return copy;
    }

    @FXML
    public void add() {
        this.showOrderEntryPopup(null);
    }

    private void showOrderEntryPopup(Order order) {
        if (order == null) {
            order = new Order();
        }
        order.setStatus(OrderStatus.ACTIVE);
        order.setOrderType(OrderType.REGULAR);
        order.setDirection(Direction.BUY);
        this.getAppContext().getService(OrderPopup.class).showExtendedOrderPopup(order, true, this);
    }

    @FXML
    public void edit() {
        OrderPopup orderPopup = this.getAppContext().getService(OrderPopup.class);
        this.getSelectedOrder().ifPresent(order -> orderPopup.showExtendedOrderPopup((Order)order, true, this));
    }

    @FXML
    public void reset() {
        this.basket.clear();
        this.logReset();
    }

    @FXML
    public void delete() {
        ArrayList selectedEntries = new ArrayList(this.basketTable.getSelectionModel().getSelectedItems());
        selectedEntries.forEach(this.basket::remove);
    }

    private boolean isSubmittable(KeyEvent keyEvent) {
        return this.getContentTab() != null && this.getContentTab().getTabPane() != null && this.getContentTab().equals(this.getContentTab().getTabPane().getSelectionModel().getSelectedItem()) && this.getScene() != null && this.getScene().getWindow() != null && this.getScene().getWindow().isFocused();
    }

    @FXML
    public void submit() {
        List<Order> ordersToSubmit = this.getOrdersToSubmit();
        if (this.marketStateQueries.findMarketState().getAll().anyMatch(m -> m.getStatus() == MarketStatus.HIBERNATE)) {
            this.userAlertService.showConfirmationDialog(Util.getLabel("commons_market"), Util.getLabel("basketIsInHalt"), UserAlertService.Flag.ERROR);
            this.logSubmitHalted();
        } else if (this.orderEntryProtectionService.checkOrders(ordersToSubmit)) {
            OrdersToSend ordersToSend = new OrdersToSend(ordersToSubmit, RequestType.ADD, (BasketRestriction)((Object)this.basket.restrictionProperty().get()), this.basket, null);
            this.orderSender.sendOrder(ordersToSend, false);
            this.logSubmit(ordersToSend);
            this.basket.markSubmitted();
        }
    }

    private void logReset() {
        LOG.info("Clear pressed" + this.getBasketStatus());
    }

    private void logSubmitHalted() {
        LOG.info("submitted when market halted" + this.getBasketStatus());
    }

    private void logSubmit(OrdersToSend ordersToSend) {
        LOG.info("submitted {} orders {}{}", ordersToSend.getOrders().size(), this.getBasketStatus(), this.getOrderIds(ordersToSend));
    }

    private String getBasketStatus() {
        return " | basket entries: " + this.basket.getEntries().size() + " / orders: " + this.basket.getOrders().size();
    }

    private String getOrderIds(OrdersToSend ordersToSend) {
        return " | order IDs: " + ordersToSend.getOrders().stream().map(Order::getClientOrderId).collect(Collectors.joining(", "));
    }

    private List<Order> getOrdersToSubmit() {
        return new ArrayList<Order>(this.basket.getOrders());
    }

    private Optional<Order> getSelectedOrder() {
        return Optional.of((BasketEntry)this.basketTable.getSelectionModel().getSelectedItem()).map(BasketEntry::getOrder);
    }

    private void importOrders(List<Order> orderList) {
        int addedOrders = 0;
        try {
            if (!this.tradingSettingsService.isBasketValidation() || this.isImportValid(orderList)) {
                addedOrders = this.addToBasket(orderList);
            }
        }
        catch (BasketFullException e) {
            this.messagePublisher.publishMessage(Util.getLabel("basketPanel_basketFullOnImport", e.getAllowed()), MessageSeverity.ERROR);
            LOG.warn(Util.getLabel("basketPanel_basketFullOnImport", e.getAllowed()));
        }
        if (addedOrders > 0) {
            this.messagePublisher.publishMessage(Util.getLabel("basket_order_orderImportOk", addedOrders), MessageSeverity.LOW);
            LOG.info(Util.getLabel("basket_order_orderImportOk", addedOrders), (Object)this.getBasketStatus());
        }
    }

    private boolean isImportValid(List<Order> orderList) {
        SortedMap<Integer, Long> duplicateRows = this.importCheckDuplicities(orderList);
        boolean isImportValid = true;
        if (!duplicateRows.isEmpty()) {
            String duplicateOrdersMsg = orderList.size() == 1 ? Util.getLabel("basketPanel_duplicateOrder") : Util.getLabel("basketPanel_duplicateOrders", duplicateRows.keySet().toString());
            isImportValid = this.userAlertService.showQuestionDialog(Util.getLabel("commons_basket"), duplicateOrdersMsg, UserAlertService.Flag.WARNING);
            LOG.warn(duplicateOrdersMsg);
        }
        return isImportValid;
    }

    private int addToBasket(List<Order> orderList) throws BasketFullException {
        int addedOrders = 0;
        for (Order o : orderList) {
            this.basket.add(o);
            ++addedOrders;
        }
        return addedOrders;
    }

    private SortedMap<Integer, Long> importCheckDuplicities(List<Order> orderList) {
        if (orderList.isEmpty() || this.basket.getOrders().isEmpty()) {
            return Collections.emptySortedMap();
        }
        TreeMap<Integer, Long> orderCounts = new TreeMap<Integer, Long>();
        int i = 1;
        for (Order o : orderList) {
            Long count = 0L;
            try {
                count = this.basket.getOrders().stream().filter(b -> o.getDeliveryArea().equals(b.getDeliveryArea()) && o.getContract().getName().equals(b.getContract().getName()) && o.getDirection().equals(b.getDirection()) && Objects.equals(o.getInitialQuantity(), b.getInitialQuantity()) && Objects.equals(o.getRemainingQuantity(), b.getRemainingQuantity()) && Objects.equals(o.getPeakQuantity(), b.getPeakQuantity()) && Objects.equals(o.getPeakPriceDelta(), b.getPeakPriceDelta()) && Objects.equals(o.getLimitPrice(), b.getLimitPrice()) && Objects.equals(o.getStopPrice(), b.getStopPrice()) && o.getAccount().equals(b.getAccount()) && o.getOrderType().equals(b.getOrderType()) && o.getStatus().equals(b.getStatus()) && o.getExecutionRestriction().equals(b.getExecutionRestriction()) && o.getValidityRestriction().equals(b.getValidityRestriction()) && Objects.equals(o.getValidityDate(), b.getValidityDate()) && (StringUtils.isAllBlank(o.getText(), b.getText()) || StringUtils.equals(o.getText(), b.getText())) && o.getBalancingGroupId().equals(b.getBalancingGroupId())).count();
            }
            catch (Exception e) {
                LOG.error("Error while retrieving duplicities in the basket.", e);
            }
            if (count > 0L) {
                orderCounts.put(i, count);
            }
            ++i;
        }
        return orderCounts;
    }

    @FXML
    public void importCSV() {
        this.importOrders(this.getAppContext().getService(ImportExportService.class).importFromCsvFile(this.getScene().getWindow()));
    }

    @FXML
    public void importClipboard() {
        this.importOrders(this.getAppContext().getService(ImportExportService.class).importFromClipboard());
    }

    @FXML
    public void switchAllToFOK() {
        this.basket.switchAllToFOK();
    }

    @Override
    public BasketPanelState getComponentState() {
        return new BasketPanelState(StorableTableLayoutDescriptor.fromTable(this.basketTable), this.menu.isExpanded(), this.bottomToolbar.getState());
    }

    @Override
    public void restoreComponentState(BasketPanelState componentState) {
        componentState.getBasketTableDescriptor().applyToTable(this.basketTable);
        this.bottomToolbar.applyToolbarItemState(componentState.getBottomToolbarStoredState());
        this.menu.setExpanded(componentState.isMenuExpanded());
    }

    @Override
    public void destroy() {
        this.submitBasketShortcutHandle.unregister();
        super.destroy();
    }

    public List<GlobalKeyboardShortcuts.KeyboardShortcutHandle> getKeyboardShortcutHandles() {
        return Collections.singletonList(this.submitBasketShortcutHandle);
    }
}

