/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control;

import com.deutscheboerse.comxerv.comtrader.core.util.DisplayName;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.type.ContractPhase;
import com.deutscheboerse.comxerv.comtrader.entities.type.ContractType;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.DisplayNameArrowKeyBlockingChoiceBox;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;

public abstract class ContractDependentChoiceBox<T extends DisplayName>
extends DisplayNameArrowKeyBlockingChoiceBox<T> {
    private final ObjectProperty<ContractType> contractType;
    private final BooleanProperty otcOnlyProduct;
    private final BooleanProperty liftOrderProduct;
    private final BooleanProperty stopOrderProduct;
    private final BooleanProperty otcTradingSupported;
    private final BooleanProperty icebergOrdersSupported;
    private final BooleanProperty auctionContract;
    private final ObjectProperty<Contract> contract = new SimpleObjectProperty<Contract>();

    protected ContractDependentChoiceBox() {
        this.contractType = new SimpleObjectProperty<ContractType>();
        this.otcOnlyProduct = new SimpleBooleanProperty(false);
        this.liftOrderProduct = new SimpleBooleanProperty(false);
        this.stopOrderProduct = new SimpleBooleanProperty(false);
        this.otcTradingSupported = new SimpleBooleanProperty(false);
        this.icebergOrdersSupported = new SimpleBooleanProperty(false);
        this.auctionContract = new SimpleBooleanProperty(false);
        this.contract.addListener((observable2, oldValue, newContract) -> {
            boolean contractNotNull = newContract != null;
            this.contractType.setValue(contractNotNull ? newContract.getType() : null);
            this.otcOnlyProduct.setValue(contractNotNull && newContract.getProduct().isOtcOnlyProduct());
            this.liftOrderProduct.setValue(contractNotNull && newContract.getProduct().isLiftOrderProduct());
            this.stopOrderProduct.setValue(contractNotNull && newContract.getProduct().isStopOrderSupported());
            this.otcTradingSupported.setValue(contractNotNull && newContract.getProduct().isOtcTradingSupported());
            this.icebergOrdersSupported.setValue(contractNotNull && newContract.getProduct().isIcebergOrdersSupported());
            this.auctionContract.setValue(contractNotNull && newContract.getCompoundStatus().getTradingPhase() == ContractPhase.AUCT);
            this.refresh();
        });
    }

    protected abstract void refresh();

    public Contract getContract() {
        return (Contract)this.contract.get();
    }

    public ObjectProperty<Contract> contractProperty() {
        return this.contract;
    }

    public void setContract(Contract contract) {
        this.contract.set(contract);
    }

    public boolean isAuctionContract() {
        return this.auctionContract.get();
    }

    public ReadOnlyBooleanProperty auctionContractProperty() {
        return this.auctionContract;
    }

    public boolean isOtcTradingSupported() {
        return this.otcTradingSupported.get();
    }

    public ReadOnlyBooleanProperty otcTradingSupportedProperty() {
        return this.otcTradingSupported;
    }

    public boolean isIcebergOrdersSupported() {
        return this.icebergOrdersSupported.get();
    }

    public ReadOnlyBooleanProperty icebergOrdersSupportedProperty() {
        return this.icebergOrdersSupported;
    }

    public boolean isOtcOnlyProduct() {
        return this.otcOnlyProduct.get();
    }

    public ReadOnlyBooleanProperty otcOnlyProductProperty() {
        return this.otcOnlyProduct;
    }

    public boolean isLiftOrderProduct() {
        return this.liftOrderProduct.get();
    }

    public ReadOnlyBooleanProperty liftOrderProductProperty() {
        return this.liftOrderProduct;
    }

    public boolean isStopOrderProduct() {
        return this.stopOrderProduct.get();
    }

    public ReadOnlyBooleanProperty stopOrderProductProperty() {
        return this.stopOrderProduct;
    }

    public ContractType getContractType() {
        return (ContractType)((Object)this.contractType.get());
    }

    public ReadOnlyObjectProperty<ContractType> contractTypeProperty() {
        return this.contractType;
    }
}

