/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control;

import com.deutscheboerse.comxerv.comtrader.entities.type.ContractStatus;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.toolbar.BottomToolbarNode;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.toolbar.StorableBottomToolbarNode;
import com.deutscheboerse.comxerv.comtrader.jfx.util.TooltipUtils;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Stream;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.MenuButton;

public class ContractStatusFilterChoiceBox
extends MenuButton
implements BottomToolbarNode,
StorableBottomToolbarNode<ArrayList<ContractStatus>> {
    private final ObjectProperty<List<ContractStatus>> selectedContractStatuses = new SimpleObjectProperty<List<ContractStatus>>();
    private final InvalidationListener recomputeSelectedContractStatuses;

    public ContractStatusFilterChoiceBox() {
        this.setText(Util.getLabel("commons_status"));
        EnumSet.allOf(ContractStatus.class).stream().filter(c -> !ContractStatus.IACT.equals(c)).forEach(c -> this.getItems().add(new ContractStatusMenuItem((ContractStatus)c)));
        this.recomputeSelectedContractStatuses = observable2 -> this.recomputeSelectedContractStatuses();
        this.recomputeSelectedContractStatuses();
        this.getContractStatusMenuItems().map(CheckMenuItem::selectedProperty).forEach(p -> p.addListener(this.recomputeSelectedContractStatuses));
        TooltipUtils.setTooltip(this, this.getDescription());
    }

    @Override
    public Node getPreviewForConfigTable() {
        MenuButton menuButton = new MenuButton();
        menuButton.textProperty().bind(this.textProperty());
        menuButton.prefWidthProperty().bind(this.widthProperty());
        menuButton.setDisable(true);
        return menuButton;
    }

    @Override
    public String getDescription() {
        return Util.getLabel("descriptions_toolbar_marketOverview_status");
    }

    @Override
    public ArrayList<ContractStatus> getState() {
        ArrayList<ContractStatus> contractStatuses = new ArrayList<ContractStatus>();
        contractStatuses.addAll((Collection)this.selectedContractStatuses.get());
        return contractStatuses;
    }

    private void recomputeSelectedContractStatuses() {
        this.selectedContractStatuses.set(this.getContractStatusMenuItems().filter(CheckMenuItem::isSelected).map(ContractStatusMenuItem::getValue).toList());
    }

    public List<ContractStatus> getSelectedContractStatuses() {
        return (List)this.selectedContractStatuses.get();
    }

    public ObjectProperty<List<ContractStatus>> selectedContractStatusesProperty() {
        return this.selectedContractStatuses;
    }

    private Stream<ContractStatusMenuItem> getContractStatusMenuItems() {
        return this.getItems().stream().filter(ContractStatusMenuItem.class::isInstance).map(ContractStatusMenuItem.class::cast);
    }

    @Override
    public void restoreSavedState(ArrayList<ContractStatus> state) {
        this.getContractStatusMenuItems().forEach(menuItem -> menuItem.setSelected(state.contains(menuItem.getValue())));
    }

    protected static final class ContractStatusMenuItem
    extends CheckMenuItem {
        private final ContractStatus contractStatus;

        private ContractStatusMenuItem(ContractStatus contractStatus) {
            this.setText(contractStatus.getDisplayName());
            this.setSelected(true);
            this.contractStatus = contractStatus;
        }

        protected ContractStatus getValue() {
            return this.contractStatus;
        }
    }
}

