/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control;

import com.deutscheboerse.comxerv.comtrader.entities.type.OrderType;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.ContractDependentChoiceBox;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class OrderTypeChoiceBoxCx
extends ContractDependentChoiceBox<OrderType> {
    private boolean isNewOrder;
    private boolean isBalancingUser;
    private boolean isBasketMode;
    private static final OrderType[] ALL_SELECTABLE_ITEMS = new OrderType[]{OrderType.REGULAR, OrderType.ICEBERG, OrderType.BALANCE, OrderType.OTC_PREARRANGED, OrderType.CONFIDENTIAL, OrderType.STOP};

    public OrderTypeChoiceBoxCx() {
        this.init(true, true, false, null);
    }

    @Override
    public void refresh() {
        this.init(this.isNewOrder, this.isBalancingUser, this.isBasketMode, (OrderType)this.getValue());
    }

    public void init(boolean isNewOrder, boolean isBalancingUser, boolean isBasketMode, OrderType value) {
        this.isNewOrder = isNewOrder;
        this.isBalancingUser = isBalancingUser;
        this.isBasketMode = isBasketMode;
        if (value == null) {
            value = OrderType.REGULAR;
        }
        this.setDisable(!isNewOrder && (value == OrderType.BALANCE || value == OrderType.OTC_PREARRANGED));
        List<OrderType> listedItems = this.computeItems(value);
        this.setListedItems(listedItems);
        if (listedItems.contains(value)) {
            this.setValue(value);
        }
    }

    private List<OrderType> computeItems(OrderType value) {
        ArrayList<OrderType> orderTypes = this.isNewOrder ? Lists.newArrayList(ALL_SELECTABLE_ITEMS) : (value == OrderType.REGULAR || value == OrderType.ICEBERG || value == OrderType.STOP ? Lists.newArrayList(OrderType.REGULAR, OrderType.ICEBERG, OrderType.STOP) : Lists.newArrayList(value));
        orderTypes.remove(OrderType.CONFIDENTIAL);
        if (!this.isBalancingUser) {
            orderTypes.remove(OrderType.BALANCE);
        }
        if (this.isBasketMode || !this.isOtcTradingSupported()) {
            orderTypes.remove(OrderType.OTC_PREARRANGED);
        }
        if (!this.isIcebergOrdersSupported() || this.getContractType().isBlock()) {
            orderTypes.remove(OrderType.ICEBERG);
        }
        if (!this.isStopOrderProduct()) {
            orderTypes.remove(OrderType.STOP);
        }
        return orderTypes;
    }
}

