/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.customization.toolbar;

import com.deutscheboerse.comxerv.comtrader.jfx.components.Destroyable;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.toolbar.BottomToolbarNode;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.toolbar.LabeledBottomToolbarNode;
import com.deutscheboerse.comxerv.comtrader.jfx.util.TooltipUtils;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;

@DefaultProperty(value="wrapped")
public class LabeledBottomToolbarNodeWrapper<T extends BottomToolbarNode>
extends HBox
implements BottomToolbarNode,
LabeledBottomToolbarNode,
Destroyable {
    private final ObjectProperty<T> wrapped;
    private final Label label;
    private final StringProperty labelText;
    private final BooleanProperty showLabel = new SimpleBooleanProperty(true);

    public LabeledBottomToolbarNodeWrapper() {
        this.wrapped = new SimpleObjectProperty();
        this.labelText = new SimpleStringProperty();
        this.label = new Label();
        this.label.textProperty().bind(this.labelText);
        this.getChildren().addAll((Node[])new Node[]{this.label});
        this.wrapped.addListener(this::wrappedChanged);
        this.showLabel.addListener(this::showLabelChanged);
    }

    private void showLabelChanged(ObservableValue<? extends Boolean> observable2, Boolean oldValue, Boolean newValue) {
        this.getChildren().remove(this.label);
        if (newValue.booleanValue()) {
            this.getChildren().add(0, this.label);
        }
    }

    private void wrappedChanged(ObservableValue<? extends T> observable2, T oldValue, T newValue) {
        if (oldValue != null) {
            this.getChildren().remove((Node)oldValue);
            if (oldValue instanceof Destroyable) {
                ((Destroyable)oldValue).destroy();
            }
        }
        if (newValue instanceof Node) {
            this.getChildren().add((Node)newValue);
        }
        TooltipUtils.setTooltip(this.label, this.getDescription());
    }

    @Override
    public Node getPreviewForConfigTable() {
        if (this.getWrapped() != null) {
            return this.getWrapped().getPreviewForConfigTable();
        }
        return null;
    }

    @Override
    public String getDescription() {
        if (this.getWrapped() != null) {
            return this.getWrapped().getDescription();
        }
        return null;
    }

    public T getWrapped() {
        return (T)((BottomToolbarNode)this.wrapped.get());
    }

    public ObjectProperty<T> wrappedProperty() {
        return this.wrapped;
    }

    public void setWrapped(T wrapped) {
        this.wrapped.set(wrapped);
    }

    public String getLabelText() {
        return (String)this.labelText.get();
    }

    public StringProperty labelTextProperty() {
        return this.labelText;
    }

    public void setLabelText(String labelText) {
        this.labelText.set(labelText);
    }

    @Override
    public boolean isShowLabel() {
        return this.showLabel.get();
    }

    @Override
    public BooleanProperty showLabelProperty() {
        return this.showLabel;
    }

    @Override
    public void setShowLabel(boolean showLabel) {
        this.showLabel.set(showLabel);
    }

    @Override
    public void destroy() {
        if (this.getWrapped() instanceof Destroyable) {
            ((Destroyable)this.getWrapped()).destroy();
        }
    }
}

