/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.filter.column;

import com.deutscheboerse.comxerv.comtrader.jfx.components.control.filter.FilterValueField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.ColumnFilter;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.PredicateType;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;

public class BooleanColumnFilter
implements ColumnFilter<Boolean, String> {
    @Override
    public List<PredicateType> getPredicateTypes() {
        return Lists.newArrayList(PredicateType.IS_TRUE, PredicateType.IS_FALSE);
    }

    @Override
    public FilterValueField<String> getValueField(PredicateType predicateType) {
        return null;
    }

    @Override
    public boolean matches(PredicateType predicateType, Boolean cellValue, String filterValue) {
        switch (predicateType) {
            case IS_TRUE: {
                return BooleanUtils.isTrue(cellValue);
            }
            case IS_FALSE: {
                return BooleanUtils.isFalse(cellValue);
            }
        }
        throw new IllegalArgumentException("Invalid predicate type");
    }
}

