/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.h2h;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.service.LocalService;
import com.deutscheboerse.comxerv.comtrader.service.time.TimeService;
import javafx.util.StringConverter;
import org.joda.time.Days;
import org.joda.time.Interval;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class ExtractDateStringFromIntervalConverter
extends StringConverter<Interval> {
    private final TimeService timeService;
    private final LocalService localService;
    private static final String TOMORROW_PREFIX = "T";
    private static final String SEPERATOR = "-";
    private static final DateTimeFormatter HOUR_FORMAT_DST = DateTimeFormat.forPattern("HH'T'");
    private static final DateTimeFormatter HOUR_FORMAT = DateTimeFormat.forPattern("HH");

    public ExtractDateStringFromIntervalConverter(ApplicationContext appContext) {
        this.timeService = appContext.getService(TimeService.class);
        this.localService = appContext.getService(LocalService.class);
    }

    @Override
    public String toString(Interval interval) {
        if (interval == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < Days.daysBetween(this.timeService.getServerTime().toLocalDate(), interval.getStart().toLocalDate()).getDays(); ++i) {
            stringBuilder.append(TOMORROW_PREFIX);
        }
        String fromDate = this.localService.getJodaDateFormat().print(HOUR_FORMAT_DST, HOUR_FORMAT, interval.getStart());
        String toDate = this.localService.getJodaDateFormat().print(HOUR_FORMAT_DST, HOUR_FORMAT, interval.getEnd());
        stringBuilder.append(fromDate);
        stringBuilder.append(SEPERATOR);
        stringBuilder.append(toDate);
        return stringBuilder.toString();
    }

    @Override
    public Interval fromString(String s) {
        throw new UnsupportedOperationException();
    }
}

