/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.layout;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.AbstractPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.Destroyable;
import com.deutscheboerse.comxerv.comtrader.jfx.components.layout.PanelOverlay;
import com.deutscheboerse.comxerv.comtrader.jfx.service.ComponentAccessService;
import com.deutscheboerse.comxerv.comtrader.service.event.OwnUserLoadedEvent;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;

public class DisabledOverlay
extends BorderPane
implements PanelOverlay,
Destroyable {
    private final BooleanProperty shouldBeVisible;
    private final ApplicationContext applicationContext;
    private final Class<? extends AbstractPanel> panelClass;
    private final EventBus eventBus;

    public DisabledOverlay(ApplicationContext applicationContext, Class<? extends AbstractPanel> panelClass) {
        this.applicationContext = applicationContext;
        this.panelClass = panelClass;
        this.eventBus = applicationContext.getService(EventBus.class);
        this.shouldBeVisible = new SimpleBooleanProperty(!this.isComponentAllowedForCurrentUser());
        FXMLLoaderWithContext.loadCustomComponent(applicationContext, this);
        this.eventBus.register(this);
    }

    @Subscribe
    public void notifyLoadingFinished(OwnUserLoadedEvent event) {
        this.shouldBeVisible.setValue(!this.isComponentAllowedForCurrentUser());
    }

    private boolean isComponentAllowedForCurrentUser() {
        return this.applicationContext.getService(ComponentAccessService.class).isComponentAllowedForCurrentUser(this.panelClass);
    }

    @Override
    public void destroy() {
        this.eventBus.unregister(this);
    }

    @Override
    public Pane getOverlayPane() {
        return this;
    }

    @Override
    public ReadOnlyBooleanProperty shouldBeVisible() {
        return this.shouldBeVisible;
    }
}

