/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.login;

import com.deutscheboerse.comxerv.comtrader.app.login.MasterLoginModel;
import com.deutscheboerse.comxerv.comtrader.app.login.MasterLoginWindow;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.jfx.GuiMessageRecorder;
import com.deutscheboerse.comxerv.comtrader.jfx.components.AboutPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.FXMLBorderPane;
import com.deutscheboerse.comxerv.comtrader.jfx.components.SettingsPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.icon.IconView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.model.GuiMessageType;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfigurationsExecutor;
import com.deutscheboerse.comxerv.comtrader.jfx.service.CloseConfirmationService;
import com.deutscheboerse.comxerv.comtrader.jfx.service.MainPanelService;
import com.deutscheboerse.comxerv.comtrader.jfx.service.MasterProfileService;
import com.deutscheboerse.comxerv.comtrader.jfx.service.WindowService;
import com.deutscheboerse.comxerv.comtrader.jfx.service.manual.ManualService;
import com.deutscheboerse.comxerv.comtrader.jfx.service.style.FontService;
import com.deutscheboerse.comxerv.comtrader.module.WorkerExecutor;
import com.deutscheboerse.comxerv.comtrader.service.BackendConnectionGateway;
import com.deutscheboerse.comxerv.comtrader.service.LoginException;
import com.deutscheboerse.comxerv.comtrader.service.LoginService;
import com.deutscheboerse.comxerv.comtrader.service.profile.ProfileManager;
import com.deutscheboerse.comxerv.comtrader.service.profile.ProfileServiceAuthenticationException;
import com.deutscheboerse.comxerv.comtrader.service.settings.SettingsService;
import com.deutscheboerse.comxerv.comtrader.service.version.VersionService;
import com.deutscheboerse.comxerv.comtrader.util.FileUtil;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.comxerv.comtrader.util.concurrent.FutureExecutor;
import com.deutscheboerse.m7.comtrader.remote.profilestorage.v3.ProfileServiceException;
import com.google.common.eventbus.EventBus;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.prefs.Preferences;
import javafx.fxml.FXML;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLoginPanel
extends FXMLBorderPane
implements MasterLoginWindow {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractLoginPanel.class);
    protected final Preferences preferences;
    protected final ProfileManager profileManager;
    protected final BackendConnectionGateway backendConnectionGateway;
    protected final LoginService loginService;
    protected final ExecutorService loginTasksExecutor;
    protected final FutureExecutor futureExecutor;
    protected final MasterProfileService masterProfileService;
    private final Stage stage;
    private final CloseConfirmationService closeConfirmationService;
    protected final SettingsService settingsService;
    protected final MainPanelService mainPanelService;
    protected final MasterLoginModel masterLoginModel = this.getAppContext().getService(MasterLoginModel.class);
    @FXML
    protected MenuItem loadDefaultProfileMenuItem;
    @FXML
    protected MenuItem loadLastSavedProfileMenuItem;
    @FXML
    protected Label statusLabel;
    @FXML
    protected MenuItem openSettingsMenuItem;
    @FXML
    protected MenuItem exitMenuItem;
    @FXML
    protected MenuItem manualMenuItem;
    @FXML
    protected MenuItem recordMessagesMenuItem;

    public AbstractLoginPanel(ApplicationContext appContext) {
        super(appContext);
        this.settingsService = this.getAppContext().getService(SettingsService.class);
        this.profileManager = this.getAppContext().getService(ProfileManager.class);
        this.masterProfileService = this.getAppContext().getService(MasterProfileService.class);
        this.backendConnectionGateway = this.getAppContext().getService(BackendConnectionGateway.class);
        this.loginService = this.getAppContext().getService(LoginService.class);
        this.closeConfirmationService = this.getAppContext().getService(CloseConfirmationService.class);
        this.loginTasksExecutor = this.getAppContext().getService(ExecutorService.class, WorkerExecutor.class);
        this.futureExecutor = new FutureExecutor(this.loginTasksExecutor);
        this.mainPanelService = this.getAppContext().getService(MainPanelService.class);
        this.preferences = Preferences.userNodeForPackage(AbstractLoginPanel.class);
        this.stage = new Stage();
        this.stage.setScene(new Scene(this));
        String version = appContext.getService(VersionService.class).getComtraderVersion();
        this.stage.setTitle(Util.getLabel("application_name") + " " + version);
        this.stage.centerOnScreen();
        this.stage.setResizable(false);
        this.closeConfirmationService.addWindowCloseConfirmationHandler(this.stage);
        this.getAppContext().getService(WindowService.class).decorateWindow(this.stage);
    }

    public void initialize() {
        this.getAppContext().getService(EventBus.class).register(this);
        this.exitMenuItem.setAccelerator(new KeyCodeCombination(KeyCode.F4, KeyCombination.ALT_DOWN));
        this.manualMenuItem.setAccelerator(new KeyCodeCombination(KeyCode.F1, new KeyCombination.Modifier[0]));
        this.recordMessagesMenuItem.setAccelerator(new KeyCodeCombination(KeyCode.R, KeyCombination.CONTROL_DOWN, KeyCombination.ALT_DOWN));
        this.getAppContext().getService(OverrideGuiConfigurationsExecutor.class).registerAndApply(this);
    }

    protected void profileLoadSuccess() {
        this.settingsService.loadAllSettings();
        this.mainPanelService.loadSavedMainPanels();
    }

    @Override
    public void showLoginWindow() {
        this.stage.show();
        this.stage.toFront();
    }

    @Override
    public boolean isLoginWindowShowing() {
        return this.stage.isShowing();
    }

    @FXML
    public void recordMessages() {
        this.getAppContext().getService(GuiMessageRecorder.class).activateRecording();
    }

    @FXML
    public void configureLookAndFeel() {
        SettingsPanel settingsPanel = new SettingsPanel(this.getAppContext());
        settingsPanel.showSettingsPanel();
    }

    @FXML
    public void retrieveLogs() {
        FileUtil.openLogFileFolder();
    }

    @FXML
    public void exit() {
        this.closeConfirmationService.applicationExitRequested();
    }

    @FXML
    public void defaultMainPanels() {
        this.masterProfileService.loadDefaultProfile(true);
    }

    @FXML
    public void restoreSavedMainPanels() {
        this.masterProfileService.loadSavedProfile(true);
    }

    @FXML
    public void openAboutDialog() {
        this.getAppContext().getService(AboutPanel.class).showDialog();
    }

    @FXML
    public void openManualDialog() {
        this.getAppContext().getService(ManualService.class).showManual();
    }

    public void showStatusMessage(String message, GuiMessageType guiMessageType) {
        if (GuiMessageType.SUCCESS_MESSAGE == guiMessageType) {
            LOG.info(message);
        } else {
            LOG.error(message);
        }
        this.statusLabel.setText(message);
        this.statusLabel.setGraphic(new IconView(guiMessageType.getIconStyleClass()));
    }

    protected void showConnectingMessage() {
        ProgressIndicator connectingIndicator = new ProgressIndicator(-1.0);
        connectingIndicator.setPrefWidth(FontService.FontSize.NORMAL.getFontSize());
        connectingIndicator.setPrefHeight(FontService.FontSize.NORMAL.getFontSize());
        this.statusLabel.setGraphic(connectingIndicator);
        this.statusLabel.setText(Util.getLabel("singleLogin_connecting"));
    }

    public void showFailedMessage(Throwable throwable) {
        LOG.error("", throwable);
        if (throwable instanceof ExecutionException && throwable.getCause() != null) {
            this.showFailedMessage(throwable.getCause());
        } else if (throwable instanceof LoginException) {
            this.showStatusMessage(throwable.getMessage(), GuiMessageType.ERROR_MESSAGE);
        } else if (throwable instanceof ProfileServiceException) {
            this.showStatusMessage(Util.getLabel("profile_service_error", throwable.getMessage()), GuiMessageType.ERROR_MESSAGE);
        } else if (throwable instanceof ProfileServiceAuthenticationException) {
            this.showStatusMessage(Util.getLabel("remote_profile_Service_auth_error"), GuiMessageType.ERROR_MESSAGE);
        } else {
            this.showStatusMessage(Util.getLabel("unknown_error", throwable.getMessage()), GuiMessageType.ERROR_MESSAGE);
        }
    }
}

