/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.mainpanel;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModel;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.SmallFastDataModel;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.WeakDataModelListener;
import com.deutscheboerse.comxerv.comtrader.entities.BalancingGroup;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderStatus;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderType;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.Destroyable;
import com.deutscheboerse.comxerv.comtrader.jfx.components.aware.label.LabelKeyAware;
import com.deutscheboerse.comxerv.comtrader.jfx.components.mainpanel.GlobalKeyboardShortcuts;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.OrderPopup;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfiguration;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfigurationsExecutor;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.gui.KeyboardShortcutsOverrideGuiStrategy;
import com.deutscheboerse.comxerv.comtrader.jfx.util.FocusTraversalRestrictionUtils;
import com.deutscheboerse.comxerv.comtrader.service.event.UserDataResetEvent;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.emergency.EmergencyService;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.HBox;

@OverrideGuiConfiguration(field="keyboardShortcutHandles", overrideId="Shortcuts", strategy=KeyboardShortcutsOverrideGuiStrategy.class)
public class AllOrderActionButtons
extends HBox
implements Destroyable {
    @FXML
    private Button cancelAllButton;
    @FXML
    private Button deactivateAllButton;
    @FXML
    private Button activateAllButton;
    private final ObservableValue<User> currentUser;
    private final EmergencyService emergencyService;
    private boolean isCompletelyDisabled;
    private final SimpleBooleanProperty hasActiveOrders;
    private final SimpleBooleanProperty hasHibernatedOrders;
    private final List<GlobalKeyboardShortcuts.KeyboardShortcutHandle> keyboardShortcutHandles;
    private final GlobalKeyboardShortcuts globalKeyboardShortcuts;
    private final EventBus eventBus;
    private final OrderPopup orderPopup;
    private final DataModel<String, BalancingGroup> balancingGroupDataModel;
    private InvalidationListener invalidationListener = change -> this.recomputeOrderStatuses();
    private OrdersChangedListener ordersChangedListener;
    private SmallFastDataModel<Long, Order> orderDataModel;
    private Map<Order, OrderStatus> orderStatusMap;
    private long activeOrdersCount;
    private long hibernatedOrdersCount;

    public AllOrderActionButtons() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public AllOrderActionButtons(ApplicationContext appContext) {
        this.currentUser = appContext.getService(UserService.class).currentUserProperty();
        this.emergencyService = appContext.getService(EmergencyService.class);
        this.hasActiveOrders = new SimpleBooleanProperty(false);
        this.hasHibernatedOrders = new SimpleBooleanProperty(false);
        this.keyboardShortcutHandles = new ArrayList<GlobalKeyboardShortcuts.KeyboardShortcutHandle>();
        this.orderPopup = appContext.getService(OrderPopup.class);
        this.balancingGroupDataModel = appContext.getDataModel(BalancingGroup.class);
        this.eventBus = appContext.getService(EventBus.class);
        this.globalKeyboardShortcuts = appContext.getService(GlobalKeyboardShortcuts.class);
        this.createShortcut(this::showBuyPopup, KeyCode.B, KeyCombination.ALT_DOWN);
        this.createShortcut(this::showSellPopup, KeyCode.S, KeyCombination.ALT_DOWN);
        this.createShortcut(this::cancelAll, KeyCode.DELETE, KeyCombination.ALT_DOWN);
        this.createShortcut(this::hibernateAll, KeyCode.D, KeyCombination.ALT_DOWN);
        this.createShortcut(this::activateAll, KeyCode.A, KeyCombination.ALT_DOWN);
        FXMLLoaderWithContext.loadCustomComponent(appContext, this);
        this.eventBus.register(this);
        appContext.getService(OverrideGuiConfigurationsExecutor.class).registerAndApply(this);
        this.currentUser.addListener(new WeakInvalidationListener(this.invalidationListener));
        this.orderStatusMap = new HashMap<Order, OrderStatus>();
        this.orderDataModel = appContext.getSmallDataModel(Order.class);
        this.ordersChangedListener = new OrdersChangedListener();
        this.orderDataModel.registerHencePostOperationListener(new WeakDataModelListener<Order>(this.ordersChangedListener));
        this.recomputeOrderStatuses();
    }

    private void createShortcut(Runnable action, KeyCode code, KeyCombination.Modifier ... modifiers) {
        this.keyboardShortcutHandles.add(this.globalKeyboardShortcuts.registerKeyboardShortcutWhenFocused(action, new KeyCodeCombination(code, modifiers), this));
    }

    public void initialize() {
        FocusTraversalRestrictionUtils.registerListenersToGuiComponents(this.cancelAllButton, this.activateAllButton);
        this.activateAllButton.disableProperty().bind(this.hasHibernatedOrders.not());
        this.deactivateAllButton.disableProperty().bind(this.hasActiveOrders.not());
        this.cancelAllButton.disableProperty().bind(this.hasActiveOrders.or(this.hasHibernatedOrders).not());
    }

    protected void showBuyPopup() {
        this.showPopup(Direction.BUY);
    }

    protected void showSellPopup() {
        this.showPopup(Direction.SELL);
    }

    private void showPopup(Direction direction) {
        Order order = new Order();
        User onBehalfUserForExchange = this.currentUser.getValue();
        order.setId(1L);
        order.setStatus(OrderStatus.ACTIVE);
        order.setOrderType(OrderType.REGULAR);
        order.setDirection(direction);
        order.setBalancingGroup(this.balancingGroupDataModel.findById(onBehalfUserForExchange.getDefaultBalancingGroup()));
        this.orderPopup.showExtendedOrderPopup(order, false, this);
    }

    public void restoreLabels() {
        this.getChildrenUnmodifiable().forEach(node -> {
            if (node instanceof LabelKeyAware) {
                LabelKeyAware labelKeyAware = (LabelKeyAware)((Object)node);
                labelKeyAware.reloadLabel();
            }
        });
    }

    @Subscribe
    public void handleUserDataResetEvent(UserDataResetEvent userDataResetEvent) {
        this.recomputeOrderStatuses();
    }

    @Override
    public void destroy() {
        this.eventBus.unregister(this);
        this.keyboardShortcutHandles.forEach(GlobalKeyboardShortcuts.KeyboardShortcutHandle::unregister);
    }

    public List<GlobalKeyboardShortcuts.KeyboardShortcutHandle> getKeyboardShortcutHandles() {
        return this.keyboardShortcutHandles;
    }

    @FXML
    public void cancelAll() {
        this.emergencyService.deleteAll();
    }

    @FXML
    public void hibernateAll() {
        this.emergencyService.hibernateAllActive();
    }

    @FXML
    public void activateAll() {
        this.emergencyService.activateAllHibernated();
    }

    private boolean isOwnUserOrder(Order order) {
        return this.currentUser.getValue().equals(order.getUser());
    }

    private void recomputeOrderStatuses() {
        this.isCompletelyDisabled = this.currentUser.getValue() == null || this.currentUser.getValue().getRoles().isAdmin();
        this.activeOrdersCount = 0L;
        this.hibernatedOrdersCount = 0L;
        if (!this.isCompletelyDisabled) {
            this.orderStatusMap = this.orderDataModel.getAllEntitiesAsStream().filter(this::isOwnUserOrder).collect(Collectors.toMap(Function.identity(), Order::getStatus));
            for (OrderStatus orderStatus : this.orderStatusMap.values()) {
                if (OrderStatus.ACTIVE.equals(orderStatus)) {
                    ++this.activeOrdersCount;
                    continue;
                }
                if (!OrderStatus.HIBERNATE.equals(orderStatus)) continue;
                ++this.hibernatedOrdersCount;
            }
        }
        this.hasActiveOrders.set(this.activeOrdersCount > 0L);
        this.hasHibernatedOrders.set(this.hibernatedOrdersCount > 0L);
    }

    private final class OrdersChangedListener
    implements DataModelListener<Order> {
        private OrdersChangedListener() {
        }

        private void add(Order order) {
            OrderStatus oldStatus = AllOrderActionButtons.this.orderStatusMap.remove(order);
            if (AllOrderActionButtons.this.isOwnUserOrder(order)) {
                AllOrderActionButtons.this.orderStatusMap.put(order, order.getStatus());
                this.orderStatusChanged(oldStatus, order.getStatus());
            } else {
                this.orderStatusChanged(oldStatus, null);
            }
        }

        private void remove(Order order) {
            OrderStatus oldStatus = AllOrderActionButtons.this.orderStatusMap.remove(order);
            if (oldStatus != null) {
                this.orderStatusChanged(oldStatus, null);
            }
        }

        private void orderStatusChanged(OrderStatus oldStatus, OrderStatus newStatus) {
            if (oldStatus != OrderStatus.ACTIVE && newStatus == OrderStatus.ACTIVE) {
                ++AllOrderActionButtons.this.activeOrdersCount;
            } else if (oldStatus == OrderStatus.ACTIVE && newStatus != OrderStatus.ACTIVE) {
                --AllOrderActionButtons.this.activeOrdersCount;
            }
            if (oldStatus != OrderStatus.HIBERNATE && newStatus == OrderStatus.HIBERNATE) {
                ++AllOrderActionButtons.this.hibernatedOrdersCount;
            } else if (oldStatus == OrderStatus.HIBERNATE && newStatus != OrderStatus.HIBERNATE) {
                --AllOrderActionButtons.this.hibernatedOrdersCount;
            }
            AllOrderActionButtons.this.hasActiveOrders.set(AllOrderActionButtons.this.activeOrdersCount > 0L);
            AllOrderActionButtons.this.hasHibernatedOrders.set(AllOrderActionButtons.this.hibernatedOrdersCount > 0L);
        }

        @Override
        public DataModelListener.NotificationResult notifyAdd(Order object) {
            if (!AllOrderActionButtons.this.isCompletelyDisabled) {
                this.add(object);
            }
            return DataModelListener.NotificationResult.RETAIN_LISTENER;
        }

        @Override
        public DataModelListener.NotificationResult notifyAddAll(Collection<Order> objects) {
            if (!AllOrderActionButtons.this.isCompletelyDisabled) {
                objects.forEach(this::add);
            }
            return DataModelListener.NotificationResult.RETAIN_LISTENER;
        }

        @Override
        public DataModelListener.NotificationResult notifyRemove(Order object) {
            if (!AllOrderActionButtons.this.isCompletelyDisabled) {
                this.remove(object);
            }
            return DataModelListener.NotificationResult.RETAIN_LISTENER;
        }

        @Override
        public DataModelListener.NotificationResult notifyRemoveAll(Collection<Order> objects) {
            if (!AllOrderActionButtons.this.isCompletelyDisabled) {
                objects.forEach(this::remove);
            }
            return DataModelListener.NotificationResult.RETAIN_LISTENER;
        }

        @Override
        public DataModelListener.NotificationResult notifyRemoveAll() {
            if (!AllOrderActionButtons.this.isCompletelyDisabled) {
                AllOrderActionButtons.this.recomputeOrderStatuses();
            }
            return DataModelListener.NotificationResult.RETAIN_LISTENER;
        }

        @Override
        public DataModelListener.NotificationResult notifyUpdate(Order object) {
            if (!AllOrderActionButtons.this.isCompletelyDisabled) {
                this.add(object);
            }
            return DataModelListener.NotificationResult.RETAIN_LISTENER;
        }

        @Override
        public DataModelListener.NotificationResult notifyUpdateAll(Collection<Order> objects) {
            if (!AllOrderActionButtons.this.isCompletelyDisabled) {
                objects.forEach(this::add);
            }
            return DataModelListener.NotificationResult.RETAIN_LISTENER;
        }
    }
}

