/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.domain.query.OrderbookQueries;
import com.deutscheboerse.comxerv.comtrader.entities.CompoundStatus;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.entities.property.binding.IsTomorrowContractBinding;
import com.deutscheboerse.comxerv.comtrader.entities.property.binding.LongDisplayValueStringBinding;
import com.deutscheboerse.comxerv.comtrader.entities.type.ContractPhase;
import com.deutscheboerse.comxerv.comtrader.entities.type.ValueChange;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.AbstractAreaChoiceBox;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.ContractPhaseWidget;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.DeliveryAreaChoiceBox;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.FlashingLabel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.ValueChangeWidget;
import com.deutscheboerse.comxerv.comtrader.jfx.components.effect.CollapseExpandEffect;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.CloseRemoveOrderbookCallBack;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.ExtendedOrderbookTables;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.OrderPopup;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.orderbook.LastTradeTooltip;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfiguration;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfigurationsExecutor;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.gui.AllDescendantsByIdOverrideGuiStrategy;
import com.deutscheboerse.comxerv.comtrader.jfx.service.event.MarketSelectionEvent;
import com.deutscheboerse.comxerv.comtrader.jfx.util.DirectionStyleUtil;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.deutscheboerse.ui.jfx.util.StyleUtil;
import com.deutscheboerse.ui.jfx.util.binding.WeakObservableValue;
import com.google.common.eventbus.EventBus;
import java.util.Collections;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;

@OverrideGuiConfiguration(field="#this", overrideId="OrderbookPane", strategy=AllDescendantsByIdOverrideGuiStrategy.class)
public abstract class AbstractOrderbookPane
extends VBox {
    private static final String CSS_TOMORROW_CONTRACT_CLASS = "tomorrowContract";
    protected static final String VALUE_NOT_PRESENT_TEXT = "-";
    private final AbstractAreaChoiceBox switchAllDaChoiceBox;
    private final BooleanProperty expanded;
    private final CloseRemoveOrderbookCallBack closeRemoveOrderbookCallBack;
    protected final ApplicationContext appContext;
    private final OrderbookQueries orderbookQueries;
    protected final ObservableValue<Integer> rowLimit;
    protected final ObjectProperty<Orderbook> orderbook;
    private final BooleanProperty collapsible;
    private final BooleanProperty tomorrowContract;
    private CollapseExpandEffect collapseExpandEffect;
    private ChangeListener<LongDisplayValue> surplusTextStyleUpdater;
    private final LastTradeTooltip lastTradeTooltip;
    @FXML
    protected Label name;
    @FXML
    protected FlashingLabel highText;
    @FXML
    protected FlashingLabel lowText;
    @FXML
    protected FlashingLabel lastPrcText;
    @FXML
    protected FlashingLabel lastQtyText;
    @FXML
    protected FlashingLabel indAucPrcText;
    @FXML
    protected FlashingLabel surplusText;
    @FXML
    protected FlashingLabel closingPriceText;
    @FXML
    protected HBox header;
    @FXML
    protected HBox auctionHBox;
    @FXML
    protected HBox lastQtyPrcContainer;
    @FXML
    protected ExtendedOrderbookTables entryTables;
    @FXML
    protected ValueChangeWidget valueChangeWidget;
    @FXML
    protected DeliveryAreaChoiceBox daChoiceBox;
    @FXML
    protected ContractPhaseWidget phaseWidget;
    @FXML
    protected Button closeButton;

    public AbstractOrderbookPane(ApplicationContext appContext, Orderbook initialOrderbook, CloseRemoveOrderbookCallBack closeRemoveOrderbookCallBack, ObservableValue<Integer> rowLimit, AbstractAreaChoiceBox switchAllDaChoiceBox) {
        this.appContext = appContext;
        this.orderbookQueries = appContext.getService(OrderbookQueries.class);
        this.closeRemoveOrderbookCallBack = closeRemoveOrderbookCallBack;
        this.orderbook = new SimpleObjectProperty<Orderbook>();
        this.orderbook.set(initialOrderbook);
        this.expanded = new SimpleBooleanProperty(true);
        this.collapsible = new SimpleBooleanProperty(true);
        this.tomorrowContract = new SimpleBooleanProperty(false);
        this.rowLimit = rowLimit;
        this.switchAllDaChoiceBox = switchAllDaChoiceBox;
        this.lastTradeTooltip = appContext.getService(LastTradeTooltip.class);
    }

    public Orderbook getOrderbook() {
        return (Orderbook)this.orderbook.get();
    }

    public ObjectProperty<Orderbook> orderbookProperty() {
        return this.orderbook;
    }

    public void initialize() {
        Tooltip.install(this.lastQtyPrcContainer, this.lastTradeTooltip);
        this.lastQtyPrcContainer.setOnMouseEntered(event -> this.lastTradeTooltip.setOrderbook((Orderbook)this.orderbook.get()));
        this.entryTables.orderbookProperty().bindBidirectional(this.orderbook);
        this.collapseExpandEffect = new CollapseExpandEffect(this, this.entryTables, this.expanded);
        this.name.setOnMouseClicked(mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                MarketSelectionEvent selectionEvent = new MarketSelectionEvent((Orderbook)this.orderbook.get());
                this.appContext.getService(EventBus.class).post(selectionEvent);
                if (!selectionEvent.wasProcessed()) {
                    Order order = new Order();
                    order.setContract(((Orderbook)this.orderbook.get()).getContract());
                    this.appContext.getService(OrderPopup.class).showExtendedOrderPopup(order, false, this);
                }
            }
        });
        this.tomorrowContract.addListener((observable2, oldValue, newValue) -> StyleUtil.addStyleClass(this.name, CSS_TOMORROW_CONTRACT_CLASS, newValue));
        this.orderbook.addListener((observable2, oldValue, newValue) -> this.loadOrderbookProperties((Orderbook)newValue));
        this.daChoiceBox.valueProperty().addListener((observableValue, oldValue, newValue) -> {
            this.setDeliveryArea((DeliveryArea)newValue);
            if (this.switchAllDaChoiceBox != null && this.switchAllDaChoiceBox.getValue() != null && newValue != null && !newValue.equals(this.switchAllDaChoiceBox.getValue())) {
                FxUtil.runInFxThread(() -> this.switchAllDaChoiceBox.setValue(null));
            }
        });
        this.loadOrderbookProperties((Orderbook)this.orderbook.getValue());
        FxUtil.runLater(() -> this.entryTables.rowLimitProperty().bind(this.rowLimit));
        this.appContext.getService(OverrideGuiConfigurationsExecutor.class).registerAndApply(this, this.entryTables);
    }

    protected void loadOrderbookProperties(Orderbook currentOrderbookValue) {
        this.loadDAChoiceBoxFromCurrentOrderbook(currentOrderbookValue);
        this.loadStatusWidget(currentOrderbookValue);
        this.loadName(currentOrderbookValue);
        this.loadAuc(currentOrderbookValue);
        this.loadHiLow(currentOrderbookValue);
        this.loadClosingPriceText(currentOrderbookValue);
        this.loadLastPrcQty(currentOrderbookValue);
        this.loadPriceChange(currentOrderbookValue);
        this.loadTomorrowContract(currentOrderbookValue);
    }

    private void loadTomorrowContract(Orderbook currentOrderbookValue) {
        this.tomorrowContract.unbind();
        if (currentOrderbookValue != null) {
            this.tomorrowContract.bind(new IsTomorrowContractBinding(currentOrderbookValue.getContract(), currentOrderbookValue.getExchange().getSystemInfo()));
        }
    }

    private void loadDAChoiceBoxFromCurrentOrderbook(Orderbook currentOrderbookValue) {
        if (currentOrderbookValue != null) {
            DeliveryArea deliveryArea = currentOrderbookValue.getDeliveryArea();
            this.daChoiceBox.setListedItems(currentOrderbookValue.getContract().getCompoundStatus().getDeliveryAreas());
            if (deliveryArea != null) {
                this.daChoiceBox.setValue(deliveryArea);
            }
        } else {
            this.daChoiceBox.setListedItems(Collections.emptyList());
            this.daChoiceBox.setValue(null);
        }
    }

    private void loadStatusWidget(Orderbook currentOrderbookValue) {
        if (currentOrderbookValue != null) {
            this.phaseWidget.valueProperty().bind(new WeakObservableValue<ContractPhase>(currentOrderbookValue.tradingPhaseProperty()));
            CompoundStatus contractStatus = currentOrderbookValue.getContract().getCompoundStatus();
            this.phaseWidget.descriptionProperty().bind(new WeakObservableValue<String>(contractStatus.descriptionProperty()));
        } else {
            this.phaseWidget.valueProperty().unbind();
            this.phaseWidget.descriptionProperty().unbind();
        }
    }

    private void loadName(Orderbook currentOrderbookValue) {
        if (currentOrderbookValue != null) {
            WeakObservableValue<String> stringWeakObservableValue = new WeakObservableValue<String>(currentOrderbookValue.getContract().nameProperty());
            this.name.textProperty().bind(Bindings.format("%s (%s)", stringWeakObservableValue, currentOrderbookValue.getContract().getProduct().getTimeZone()));
        } else {
            this.name.textProperty().unbind();
        }
    }

    private void loadAuc(Orderbook currentOrderbookValue) {
        if (currentOrderbookValue != null && currentOrderbookValue.getExchange().supportsAuction()) {
            this.auctionHBox.setVisible(true);
            if (this.indAucPrcText != null) {
                this.indAucPrcText.textProperty().bind(new WeakObservableValue<String>(new LongDisplayValueStringBinding(currentOrderbookValue.auctionIndicativePriceProperty(), true, VALUE_NOT_PRESENT_TEXT)));
            }
            this.surplusText.textProperty().bind(new WeakObservableValue<String>(new LongDisplayValueStringBinding(currentOrderbookValue.auctionSurplusProperty(), true, VALUE_NOT_PRESENT_TEXT)));
            this.surplusTextStyleUpdater = (observable2, oldValue, newValue) -> DirectionStyleUtil.setCssClass((Node)this.surplusText, newValue == null ? 0L : newValue.getValue());
            currentOrderbookValue.auctionSurplusProperty().addListener(new WeakChangeListener<LongDisplayValue>(this.surplusTextStyleUpdater));
        } else {
            this.auctionHBox.setVisible(false);
            if (this.indAucPrcText != null) {
                this.indAucPrcText.textProperty().unbind();
            }
            this.surplusText.textProperty().unbind();
            this.surplusTextStyleUpdater = null;
        }
    }

    private void loadHiLow(Orderbook currentOrderbookValue) {
        if (currentOrderbookValue != null) {
            this.highText.textProperty().bind(new WeakObservableValue<String>(new LongDisplayValueStringBinding(currentOrderbookValue.hiProperty(), true, VALUE_NOT_PRESENT_TEXT)));
            this.lowText.textProperty().bind(new WeakObservableValue<String>(new LongDisplayValueStringBinding(currentOrderbookValue.lowProperty(), true, VALUE_NOT_PRESENT_TEXT)));
        } else {
            this.highText.textProperty().unbind();
            this.lowText.textProperty().unbind();
        }
    }

    private void loadClosingPriceText(Orderbook currentOrderbookValue) {
        if (currentOrderbookValue != null) {
            this.closingPriceText.textProperty().bind(new WeakObservableValue<String>(new LongDisplayValueStringBinding(currentOrderbookValue.closingPriceProperty(), true, VALUE_NOT_PRESENT_TEXT)));
        } else {
            this.closingPriceText.textProperty().unbind();
        }
    }

    private void loadLastPrcQty(Orderbook currentOrderbookValue) {
        if (currentOrderbookValue != null) {
            this.lastPrcText.textProperty().bind(new WeakObservableValue<String>(new LongDisplayValueStringBinding(currentOrderbookValue.lastPriceProperty(), true, VALUE_NOT_PRESENT_TEXT)));
            this.lastQtyText.textProperty().bind(new WeakObservableValue<String>(new LongDisplayValueStringBinding(currentOrderbookValue.lastQuantityProperty(), true, VALUE_NOT_PRESENT_TEXT)));
            this.valueChangeWidget.valueProperty().addListener(observable2 -> DirectionStyleUtil.setCssClass((Node)this.lastPrcText, (ValueChange)((Object)((Object)currentOrderbookValue.priceChangeProperty().getValue()))));
            DirectionStyleUtil.setCssClass((Node)this.lastPrcText, (ValueChange)((Object)currentOrderbookValue.priceChangeProperty().getValue()));
        } else {
            this.lastPrcText.textProperty().unbind();
            this.lastQtyText.textProperty().unbind();
        }
    }

    private void loadPriceChange(Orderbook currentOrderbookValue) {
        if (currentOrderbookValue != null) {
            this.valueChangeWidget.valueProperty().bind(new WeakObservableValue<ValueChange>(currentOrderbookValue.priceChangeProperty()));
        } else {
            this.valueChangeWidget.valueProperty().unbind();
            this.valueChangeWidget.setValue(null);
        }
    }

    public void expand() {
        this.collapseExpandEffect.expand();
    }

    public void collapse() {
        if (this.collapsible.get()) {
            this.collapseExpandEffect.collapse();
        }
    }

    @FXML
    public void toggleCollapse(MouseEvent event) {
        if (event.getClickCount() == 2 && this.collapsible.get()) {
            this.collapseExpandEffect.toggle();
        }
    }

    public void setVisibilityOfCloseButton(boolean visible) {
        this.closeButton.visibleProperty().set(visible);
    }

    @FXML
    public void close() {
        this.closeRemoveOrderbookCallBack.closeOrderbookPane(this);
    }

    public void setMinRows(int minRows) {
        this.entryTables.setMinRows(minRows);
    }

    public void setCollapsible(boolean collapsible) {
        this.collapsible.set(collapsible);
    }

    public boolean getCollapsible() {
        return this.collapsible.get();
    }

    public BooleanProperty collapsibleProperty() {
        return this.collapsible;
    }

    private void setDeliveryArea(DeliveryArea deliveryArea) {
        if (deliveryArea != null) {
            this.orderbookQueries.findByContractAndDeliveryArea(((Orderbook)this.orderbook.get()).getContract(), deliveryArea).ifPresent(this.orderbook::setValue);
        }
    }

    public ExtendedOrderbookTables getEntryTables() {
        return this.entryTables;
    }

    public boolean isExpanded() {
        return this.collapseExpandEffect.getExpanded();
    }
}

