/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.AbstractDataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.WeakDataModelListener;
import com.deutscheboerse.comxerv.comtrader.domain.query.ContractQueries;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.ContractAdditionOrigin;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.entities.type.ContractStatus;
import com.deutscheboerse.comxerv.comtrader.jfx.components.OwnMarketPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.ContractListView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.ContractRestriction;
import com.deutscheboerse.comxerv.comtrader.jfx.components.tree.AbstractContractTreeContext;
import com.deutscheboerse.comxerv.comtrader.module.WorkerExecutor;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;

public class OrderbookPanelContractTreeContext
extends AbstractContractTreeContext {
    private final ContractListView contractListView;
    private final ContractQueries contractQueries;
    private final Multimap<Product, ChangeListener<ContractStatus>> contractStatusChangeListeners;
    private final ScheduledExecutorService scheduledExecutorService;
    private final AbstractDataModelListener<Orderbook> orderbookDataModelListener;
    private final Set<Product> subscribedProducts;
    private final List<Contract> pendingAdditionsForSubscribedProducts = new ArrayList<Contract>();
    private static final long ACTIVE_CONTRACS_ADDED_DELAY_IN_MILLIS = 250L;

    public OrderbookPanelContractTreeContext(ApplicationContext applicationContext, ContractListView contractListView, Predicate<Contract> contractFilter, Predicate<Product> productFilter) {
        super(contractFilter, productFilter);
        this.contractListView = contractListView;
        this.contractQueries = applicationContext.getService(ContractQueries.class);
        this.contractStatusChangeListeners = HashMultimap.create();
        this.subscribedProducts = new HashSet<Product>();
        this.scheduledExecutorService = applicationContext.getService(ScheduledExecutorService.class, WorkerExecutor.class);
        this.orderbookDataModelListener = new AbstractDataModelListener<Orderbook>(){

            @Override
            public DataModelListener.NotificationResult notifyAdd(Orderbook object) {
                OrderbookPanelContractTreeContext.this.newOrderbookAdded(object.getContract());
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }

            @Override
            public DataModelListener.NotificationResult notifyAddAll(Collection<Orderbook> objects) {
                OrderbookPanelContractTreeContext.this.newOrderbooksAdded(objects);
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }
        };
        applicationContext.getDataModel(Orderbook.class).registerHencePostOperationListener(new WeakDataModelListener<Orderbook>(this.orderbookDataModelListener));
    }

    private void newOrderbooksAdded(Collection<Orderbook> orderbooks) {
        Set<Contract> contracts = orderbooks.stream().map(Orderbook::getContract).collect(Collectors.toSet());
        contracts.forEach(this::newOrderbookAdded);
    }

    private void newOrderbookAdded(Contract contract) {
        if (this.isSubscribed(contract.getProduct())) {
            if (!contract.getCompoundStatus().getContractStatus().isInactive()) {
                this.contractListView.addContracts(Collections.singletonList(contract), ContractRestriction.EACH_CONTRACT_ONLY_ONCE, ContractAdditionOrigin.PRODUCT_SUBSCRIPTION);
            }
            this.addContractStatusChangeListner(contract);
        }
    }

    public Set<Product> getSubscribedProducts() {
        return Collections.unmodifiableSet(this.subscribedProducts);
    }

    @Override
    public boolean isSelectable(Contract contract) {
        return true;
    }

    @Override
    public boolean isSelectable(Product product) {
        return true;
    }

    @Override
    public boolean areProductsSubscribable() {
        return true;
    }

    @Override
    public boolean areProductsSteppable() {
        return this.contractListView instanceof OwnMarketPanel;
    }

    @Override
    public void productSelected(Product product) {
        this.productSubscribed(product);
    }

    @Override
    public void contractSelected(Contract contract) {
        this.contractListView.addContracts(Collections.singletonList(contract), ContractRestriction.UNRESTRAINED, ContractAdditionOrigin.MANUAL);
    }

    @Override
    public boolean isSubscribed(Product product) {
        return this.subscribedProducts.contains(product);
    }

    @Override
    public void productSubscribed(Product product) {
        if (!this.isSubscribed(product)) {
            this.subscribedProducts.add(product);
            List<Contract> contracts = this.contractQueries.findByProduct(product).addFilter(this.getContractFilter()).getAll().toList();
            List<Contract> activeContracts = contracts.stream().filter(this::isContractNotInactive).toList();
            this.contractListView.addContracts(activeContracts, ContractRestriction.EACH_CONTRACT_ONLY_ONCE, ContractAdditionOrigin.PRODUCT_SUBSCRIPTION);
            contracts.forEach(this::addContractStatusChangeListner);
        }
    }

    private void addContractStatusChangeListner(Contract contract) {
        ContractStatusListener listener = new ContractStatusListener(contract, this);
        contract.getCompoundStatus().contractStatusProperty().addListener(new WeakChangeListener<ContractStatus>(listener));
        this.contractStatusChangeListeners.put(contract.getProduct(), listener);
    }

    private void contractStatusChanged(Contract contract, ContractStatus oldValue, ContractStatus newValue) {
        if (oldValue.isInactive() && !newValue.isInactive() && this.isSubscribed(contract.getProduct())) {
            this.pendingAdditionsForSubscribedProducts.add(contract);
            this.scheduledExecutorService.schedule(FxUtil.wrapWithRunInFxThread(this::addContractsLater), 250L, TimeUnit.MILLISECONDS);
        }
    }

    private void addContractsLater() {
        if (!this.pendingAdditionsForSubscribedProducts.isEmpty()) {
            this.contractListView.addContracts(new ArrayList<Contract>(this.pendingAdditionsForSubscribedProducts), ContractRestriction.EACH_CONTRACT_ONLY_ONCE, ContractAdditionOrigin.PRODUCT_SUBSCRIPTION);
            this.pendingAdditionsForSubscribedProducts.clear();
        }
    }

    private boolean isContractNotInactive(Contract contract) {
        return !contract.getCompoundStatus().getContractStatus().isInactive();
    }

    @Override
    public void productUnsubscribed(Product product) {
        this.subscribedProducts.remove(product);
        this.contractStatusChangeListeners.removeAll(product);
        List<Contract> contracts = this.contractQueries.findByProduct(product).addFilter(this.getContractFilter()).getAll().toList();
        this.contractListView.removeContracts(contracts);
    }

    private static class ContractStatusListener
    implements ChangeListener<ContractStatus> {
        private final Contract contract;
        private final OrderbookPanelContractTreeContext contractTreeContext;

        public ContractStatusListener(Contract contract, OrderbookPanelContractTreeContext contractTreeContext) {
            this.contract = contract;
            this.contractTreeContext = contractTreeContext;
        }

        @Override
        public void changed(ObservableValue<? extends ContractStatus> observable2, ContractStatus oldValue, ContractStatus newValue) {
            this.contractTreeContext.contractStatusChanged(this.contract, oldValue, newValue);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ContractStatusListener that = (ContractStatusListener)o;
            return Objects.equals(this.contract, that.contract);
        }

        public int hashCode() {
            return Objects.hash(this.contract);
        }
    }
}

